/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.networking;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.TechsCode.base.networking.NPlayer;

public class NServer {
    private String name;
    private String ip;
    private int port;
    private List<NPlayer> players;

    public NServer(String name, String ip, int port, List<NPlayer> players) {
        this.name = name;
        this.ip = ip;
        this.port = port;
        this.players = players;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public List<NPlayer> getPlayers() {
        return this.players;
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("ip", this.ip);
        jsonObject.addProperty("port", (Number)this.port);
        JsonArray players = new JsonArray();
        this.players.forEach(player -> players.add((JsonElement)player.toJsonObject()));
        jsonObject.add("players", (JsonElement)players);
        return jsonObject;
    }

    public static NServer fromJsonObject(JsonObject jsonObject) {
        String name = jsonObject.get("name").getAsString();
        String ip = jsonObject.get("ip").getAsString();
        int port = jsonObject.get("port").getAsInt();
        NServer server = new NServer(name, ip, port, new ArrayList<NPlayer>());
        jsonObject.get("players").getAsJsonArray().forEach(jsonElement -> server.players.add(NPlayer.fromJsonObject((JsonObject)jsonElement, server)));
        return server;
    }
}

