/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.networking;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import me.TechsCode.base.BungeeTechPlugin;
import me.TechsCode.base.messaging.Message;
import me.TechsCode.base.networking.NetworkData;
import me.TechsCode.base.networking.ServerList;

public class BungeeNetworkManager {
    private static List<String> LOCALHOST_IPS = Arrays.asList("localhost", "127.0.0.1");
    private BungeeTechPlugin plugin;
    private String ownIpAddress;

    public BungeeNetworkManager(BungeeTechPlugin plugin) {
        this.plugin = plugin;
        this.ownIpAddress = this.retrieveOwnIpAddress();
        plugin.getScheduler().runTaskTimer(this::SendServerListInfoTask, 10L, 100L);
    }

    private String retrieveOwnIpAddress() {
        try {
            return new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream())).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void SendServerListInfoTask() {
        String proxyPluginVersion = this.plugin.getVersion();
        ServerList serverList = this.fetchServerList();
        NetworkData networkData = new NetworkData(proxyPluginVersion, serverList);
        this.plugin.getMessagingService().send(new Message("networking", networkData.toJsonObject()));
    }

    private ServerList fetchServerList() {
        return null;
    }
}

