/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.messaging;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.messaging.Message;
import me.TechsCode.base.messaging.QueuedMessage;
import me.TechsCode.base.messaging.SpigotMessagingListener;
import me.TechsCode.base.scheduler.RecurringTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SpigotMessagingService
implements PluginMessageListener {
    private SpigotTechPlugin plugin;
    private List<QueuedMessage> queuedMessages;
    private RecurringTask sendTask;
    private List<SpigotMessagingListener> listeners;

    public SpigotMessagingService(SpigotTechPlugin plugin) {
        this.plugin = plugin;
        this.queuedMessages = new ArrayList<QueuedMessage>();
        this.listeners = new ArrayList<SpigotMessagingListener>();
        this.sendTask = plugin.getScheduler().runTaskTimer(this::SendTask, 1L, 1L);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)plugin.getBootstrap(), "BungeeCord");
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)plugin.getBootstrap(), "BungeeCord", (PluginMessageListener)this);
    }

    public void onDisable() {
        this.sendTask.stop();
    }

    private void SendTask() {
        Player anyPlayer = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        Iterator<QueuedMessage> iterator = this.queuedMessages.iterator();
        if (iterator.hasNext() && anyPlayer != null) {
            QueuedMessage message = iterator.next();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.plugin.getName() + "//" + message.encode());
            anyPlayer.sendPluginMessage((Plugin)this.plugin.getBootstrap(), "BungeeCord", out.toByteArray());
            message.onSend();
            this.queuedMessages.remove(message);
        }
    }

    public void register(SpigotMessagingListener listener) {
        this.listeners.add(listener);
    }

    public void onPluginMessageReceived(String channel, Player p, byte[] bytes) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            if (in.available() == 0) {
                return;
            }
            String line = in.readUTF();
            if (line.startsWith(this.plugin.getName() + "//")) {
                Message message = Message.decode(line.replace(this.plugin.getName() + "//", ""));
                this.listeners.forEach(listeners -> listeners.onMessage(message));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(QueuedMessage message) {
        for (QueuedMessage all : new ArrayList<QueuedMessage>(this.queuedMessages)) {
            if (!all.encode().equals(message.encode())) continue;
            return;
        }
        this.queuedMessages.add(message);
    }
}

