/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.loader.reloader;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.loader.reloader.PluginReloader;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPluginReloader
extends PluginReloader<SpigotTechPlugin> {
    public SpigotPluginReloader(SpigotTechPlugin plugin) {
        super(plugin);
    }

    @Override
    public void unload() {
        Bukkit.getPluginManager().disablePlugin((Plugin)((SpigotTechPlugin)this.plugin).getBootstrap());
        try {
            Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
            listenersField.setAccessible(true);
            Map listeners = (Map)listenersField.get(Bukkit.getPluginManager());
            listeners.values().forEach(set -> set.removeIf(value -> value.getPlugin() == ((SpigotTechPlugin)this.plugin).getBootstrap()));
        }
        catch (Exception listenersField) {
            // empty catch block
        }
        try {
            Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            SimpleCommandMap commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getPluginManager());
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map commands = (Map)knownCommandsField.get(commandMap);
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != ((SpigotTechPlugin)this.plugin).getBootstrap()) continue;
                c.unregister((CommandMap)commandMap);
                it.remove();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        ClassLoader cl = ((JavaPlugin)((SpigotTechPlugin)this.plugin).getBootstrap()).getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                ex.printStackTrace();
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        System.gc();
    }

    @Override
    public void load() {
        try {
            File destination = new File(URLDecoder.decode(((SpigotTechPlugin)this.plugin).getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
            Plugin loadedPlugin = Bukkit.getPluginManager().loadPlugin(destination);
            loadedPlugin.onLoad();
            Bukkit.getPluginManager().enablePlugin(loadedPlugin);
        }
        catch (UnsupportedEncodingException | InvalidDescriptionException | InvalidPluginException e) {
            e.printStackTrace();
        }
    }
}

