/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.legacy;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.visual.Text;
import org.bukkit.plugin.java.JavaPlugin;

public class Tools {
    public static String getNumberString(long l) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(l);
    }

    public static String getNumberString(double d) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(d);
    }

    public static String getNumberString(float f) {
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(f);
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String[] splitCamelCase(String str) {
        return str.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    }

    public static String firstUpperCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String[] lineSplitter(String str, int charlength) {
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        for (String word : str.split(" ")) {
            if ((line = line.trim()).length() + word.length() > charlength) {
                lines.add(line);
                line = "";
            }
            line = line + " " + word;
        }
        if ((line = line.trim()).length() != 0) {
            lines.add(line);
        }
        return lines.toArray(new String[0]);
    }

    public static String removeEofsAndLineBreakers(String var0) {
        if (var0 == null || var0.length() == 0) {
            return var0;
        }
        int var1 = var0.length();
        char[] var2 = new char[var1];
        int var3 = 0;
        int var4 = 0;
        boolean var5 = true;
        for (int var6 = 0; var6 < var1; ++var6) {
            char var7 = var0.charAt(var6);
            boolean var8 = Character.isWhitespace(var7);
            if (!var8) {
                var5 = false;
                var2[var3++] = var7 == '\u00a0' ? 32 : (int)var7;
                var4 = 0;
                continue;
            }
            if (var4 == 0 && !var5) {
                var2[var3++] = " ".charAt(0);
            }
            ++var4;
        }
        if (var5) {
            return "";
        }
        return new String(var2, 0, var3 - (var4 > 0 ? 1 : 0)).trim();
    }

    public static String getEnumName(Enum<?> enum_) {
        return String.join((CharSequence)" ", Arrays.stream(enum_.name().split("_")).map(entry -> entry.toUpperCase().charAt(0) + entry.toLowerCase().substring(1)).collect(Collectors.toCollection(ArrayList::new)));
    }

    public static String getSecretPassword(String password) {
        return String.join((CharSequence)"", Collections.nCopies(password.length(), "*"));
    }

    public static String getTicksString(long duration) {
        if (duration == 0L) {
            return duration + " Ticks";
        }
        return duration + " Tick";
    }

    public static String getTimeString(long duration) {
        return Tools.getTimeString(duration, TimeUnit.SECONDS);
    }

    public static String getTimeString(long duration, TimeUnit timeUnit) {
        return Tools.getTimeString(duration, timeUnit, 0);
    }

    public static String getTimeString(long duration, TimeUnit timeUnit, int limit) {
        if ((duration = timeUnit.toSeconds(duration)) < 1L) {
            return "Now";
        }
        long days = TimeUnit.SECONDS.toDays(duration);
        long hours = TimeUnit.SECONDS.toHours(duration -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(duration -= TimeUnit.HOURS.toSeconds(hours));
        long seconds = TimeUnit.SECONDS.toSeconds(duration -= TimeUnit.MINUTES.toSeconds(minutes));
        ArrayList result = new ArrayList();
        if (limit != 0) {
            while (result.size() > limit) {
                result.remove(result.size() - 1);
            }
        }
        return String.join((CharSequence)", ", result);
    }

    public static File exportFile(String resource, boolean replace, SpigotTechPlugin plugin) {
        File file = new File(plugin.getPluginFolder() + "/" + resource);
        if (replace || !file.exists()) {
            ((JavaPlugin)plugin.getBootstrap()).saveResource(resource, replace);
        }
        return file;
    }

    public static String getProgressBar(int current, int max, int totalBars, String symbol, String completedColor, String notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        int leftOver = totalBars - progressBars;
        StringBuilder sb = new StringBuilder();
        sb.append(Text.chatColor(completedColor));
        IntStream.range(0, progressBars).mapToObj(i -> symbol).forEach(sb::append);
        sb.append(Text.chatColor(notCompletedColor));
        IntStream.range(0, leftOver).mapToObj(i -> symbol).forEach(sb::append);
        return sb.toString();
    }

    public static long getTimeSecondsFromString(String string) {
        return Arrays.stream(string.split(" ")).mapToLong(Tools::getTimeFromWord).sum();
    }

    private static long getTimeFromWord(String string) {
        try {
            if (string.length() < 2) {
                return 0L;
            }
            String timeChar = "" + string.toCharArray()[string.length() - 1];
            int amount = Integer.parseInt(string.substring(0, string.length() - 1));
            TimeUnit[] units = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS};
            TimeUnit timeUnit = Arrays.stream(units).filter(u -> u.toString().toLowerCase().startsWith(timeChar)).findFirst().orElse(null);
            if (timeUnit == null) {
                return 0L;
            }
            return timeUnit.toSeconds(amount);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

