/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base;

import java.io.File;
import java.rmi.registry.Registry;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.loader.reloader.PluginReloader;
import me.TechsCode.base.scheduler.Scheduler;

public abstract class TechPlugin<BOOTSTRAP> {
    private final BOOTSTRAP bootstrap;
    private Registry registry;
    private List<Runnable> disableHooks;
    public static boolean isUsingLibraryLoaderSpigot;
    public static boolean isUsingLibraryLoaderBungee;

    public TechPlugin(BOOTSTRAP bootstrap) {
        long start = System.currentTimeMillis();
        this.bootstrap = bootstrap;
        if (this instanceof SpigotTechPlugin) {
            Logger logger = Logger.getLogger("NBTAPI");
            logger.setLevel(Level.SEVERE);
        }
        this.log("Loading Plugin...");
    }

    public void disable() {
        this.onDisable();
        this.onPlatformDisable();
        this.onGlobalDisable();
    }

    private boolean onGlobalEnable() {
        return true;
    }

    private void onGlobalDisable() {
        this.disableHooks.forEach(Runnable::run);
    }

    protected abstract void onEnable();

    protected abstract void onDisable();

    protected abstract void onInitialization();

    protected abstract void onPlatformEnable();

    protected abstract void onPlatformDisable();

    public BOOTSTRAP getBootstrap() {
        return this.bootstrap;
    }

    public abstract String getName();

    public abstract String getVersion();

    public abstract int getBuildNumber();

    public abstract File getPluginFolder();

    public abstract File getServerFolder();

    public abstract Scheduler getScheduler();

    public abstract PluginReloader<?> getPluginReloader();

    protected abstract void sendConsole(String var1);

    public Registry getRegistry() {
        return this.registry;
    }

    public String getPrefix() {
        return null;
    }

    public void log(String message) {
        this.sendConsole("\u00a7b[\u00a77" + this.getName() + "\u00a7b] \u00a7r" + message);
    }

    public void addDisableHook(Runnable runnable) {
        this.disableHooks.add(runnable);
    }

    public boolean isAllowingInvalidMySQL() {
        return false;
    }
}

