/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.loader.reloader.PluginReloader;
import me.TechsCode.base.loader.reloader.SpigotPluginReloader;
import me.TechsCode.base.messaging.SpigotMessagingService;
import me.TechsCode.base.scheduler.Scheduler;
import me.TechsCode.base.scheduler.SpigotScheduler;
import me.TechsCode.base.source.Maven;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SpigotTechPlugin
extends TechPlugin<JavaPlugin> {
    private SpigotScheduler scheduler;
    private SpigotMessagingService messagingService;

    public SpigotTechPlugin(JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    protected void onInitialization() {
        this.scheduler = new SpigotScheduler(this);
        this.messagingService = new SpigotMessagingService(this);
    }

    @Override
    protected void onPlatformEnable() {
        Maven.initialize(this);
        Maven.addRepository("https://repo.everit.biz/artifactory/public-release");
    }

    @Override
    protected void onPlatformDisable() {
        this.messagingService.onDisable();
    }

    @Override
    public String getName() {
        return ((JavaPlugin)this.getBootstrap()).getName();
    }

    @Override
    public String getVersion() {
        return ((JavaPlugin)this.getBootstrap()).getDescription().getVersion();
    }

    @Override
    public int getBuildNumber() {
        InputStream is = ((JavaPlugin)this.getBootstrap()).getResource("plugin.yml");
        if (is == null) {
            return 0;
        }
        return new BufferedReader(new InputStreamReader(is)).lines().filter(line -> line.startsWith("build: ")).map(line -> line.replace("build: ", "")).map(Integer::parseInt).findFirst().orElse(0);
    }

    @Override
    public File getPluginFolder() {
        return ((JavaPlugin)this.getBootstrap()).getDataFolder();
    }

    @Override
    public File getServerFolder() {
        return new File(".");
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SpigotMessagingService getMessagingService() {
        return this.messagingService;
    }

    @Override
    public PluginReloader<?> getPluginReloader() {
        return new SpigotPluginReloader(this);
    }

    @Override
    protected void sendConsole(String message) {
        Bukkit.getConsoleSender().sendMessage(message);
    }
}

