/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.UltraPunishments.storage.types.Warning;

public class WarningList
extends ArrayList<Warning> {
    public WarningList(int initialCapacity) {
        super(initialCapacity);
    }

    public WarningList() {
    }

    public WarningList(Collection<? extends Warning> c) {
        super(c);
    }

    public WarningList target(IndexedPlayer player) {
        return this.stream().filter(warning -> {
            Optional<IndexedPlayer> target = warning.getTarget().get();
            return target.isPresent() && target.get().equals(player);
        }).collect(Collectors.toCollection(WarningList::new));
    }

    public WarningList issuer(IndexedPlayer player) {
        return this.stream().filter(warning -> {
            Optional<IndexedPlayer> issuer = warning.getTarget().get();
            return issuer.isPresent() && issuer.get().equals(player);
        }).collect(Collectors.toCollection(WarningList::new));
    }

    public WarningList seen(boolean seen) {
        return this.stream().filter(warning -> warning.isSeen() == seen).collect(Collectors.toCollection(WarningList::new));
    }

    public WarningList server(String server) {
        return this.stream().filter(warning -> warning.getServer().isPresent() && warning.getServer().get().equals(server)).collect(Collectors.toCollection(WarningList::new));
    }

    public WarningList key(Integer key) {
        return this.stream().filter(warning -> warning.getKey().equals(String.valueOf(key))).collect(Collectors.toCollection(WarningList::new));
    }
}

