/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.UltraPunishments.storage.types.Punishment;
import me.TechsCode.UltraPunishments.storage.types.PunishmentType;
import me.TechsCode.base.networking.NServer;
import me.TechsCode.base.storage.Stored;

public class PunishmentList
extends ArrayList<Punishment> {
    public PunishmentList(int initialCapacity) {
        super(initialCapacity);
    }

    public PunishmentList() {
    }

    public PunishmentList(Collection<? extends Punishment> c) {
        super(c);
    }

    public PunishmentList expired(boolean expired) {
        return this.stream().filter(punishment -> punishment.isExpired() == expired).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList key(Integer key) {
        return this.stream().filter(punishment -> punishment.getKey().equals(String.valueOf(key))).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList target(IndexedPlayer player) {
        return this.target(Collections.singletonList(player.toStored()));
    }

    public PunishmentList target(List<Stored<IndexedPlayer>> targets) {
        return this.stream().filter(punishment -> punishment.getTarget().isPresent() && targets.contains(punishment.getTarget())).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList target(Stored<IndexedPlayer> ... targets) {
        return this.target(Arrays.asList(targets));
    }

    public PunishmentList issuer(Stored<IndexedPlayer> player) {
        return this.stream().filter(punishment -> punishment.getIssuer().equals(player)).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList type(PunishmentType type) {
        return this.stream().filter(punishment -> punishment.getType() == type).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList server(boolean global, NServer server) {
        return this.stream().filter(x -> x.getServer().isPresent() && server != null && x.getServer().get().equals(server.getName()) || x.isGlobal() && global).collect(Collectors.toCollection(PunishmentList::new));
    }

    public PunishmentList globalPunishments() {
        return this.stream().filter(Punishment::isGlobal).collect(Collectors.toCollection(PunishmentList::new));
    }
}

