/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.tools;

import me.TechsCode.UltraPunishments.storage.PunishmentStorage;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.UltraPunishments.storage.types.Punishment;
import me.TechsCode.UltraPunishments.storage.types.PunishmentType;
import me.TechsCode.base.networking.NServer;

public class PunishmentCreator {
    private PunishmentStorage storage;
    private IndexedPlayer target;
    private IndexedPlayer issuer;
    private NServer server;
    private PunishmentType type;
    private String reason;
    private long duration;
    private long date;

    public PunishmentCreator(PunishmentStorage storage, IndexedPlayer target, PunishmentType type) {
        this.storage = storage;
        this.target = target;
        this.type = type;
        this.date = System.currentTimeMillis();
    }

    public PunishmentCreator setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public PunishmentCreator setIssuer(IndexedPlayer issuer) {
        this.issuer = issuer;
        return this;
    }

    public PunishmentCreator setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public PunishmentCreator setServer(NServer server) {
        this.server = server;
        return this;
    }

    public Punishment create() {
        long expiry = this.duration == 0L ? 0L : System.currentTimeMillis() + this.duration;
        return this.storage.create(new Punishment(this.storage.getNextNumericId(), this.target, this.issuer, this.server, expiry, this.duration, this.reason, this.type, this.date));
    }
}

