/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.storage.types;

import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.TechsCode.UltraPunishments.storage.StorageController;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.networking.NServer;
import me.TechsCode.base.storage.Storable;
import me.TechsCode.base.storage.Stored;

public class Warning
extends Storable {
    private int id;
    private Stored<IndexedPlayer> target;
    private Stored<IndexedPlayer> issuer;
    private String server;
    private long time;
    private String reason;
    private boolean seen;
    private boolean kick;

    public Warning(int id, @Nonnull IndexedPlayer target, @Nullable IndexedPlayer issuer, NServer server, long time, String reason, boolean seen, boolean kick) {
        this.id = id;
        this.target = target.toStored();
        this.issuer = issuer != null ? issuer.toStored() : Stored.empty();
        this.server = server != null ? server.getName() : null;
        this.time = time;
        this.reason = reason;
        this.seen = seen;
        this.kick = kick;
    }

    public String getIssuerName() {
        return this.getIssuer().get().map(IndexedPlayer::getName).orElse("System");
    }

    public void remove() {
        this.destroy();
    }

    public long getTimeCreated() {
        return this.time;
    }

    public Stored<IndexedPlayer> getTarget() {
        return this.target;
    }

    public boolean hasIssuer() {
        return this.issuer.isPresent();
    }

    public Stored<IndexedPlayer> getIssuer() {
        return this.issuer;
    }

    public Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    public void setServer(String server) {
        this.server = server;
        this.sync();
    }

    public void setReason(String reason) {
        this.reason = reason;
        this.sync();
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isSeen() {
        return this.seen;
    }

    public boolean isKick() {
        return this.kick;
    }

    public void setSeen(boolean seen) {
        this.seen = seen;
        this.sync();
    }

    @Override
    public String getKey() {
        return this.id + "";
    }

    @Override
    public void setKey(String s) {
        this.id = Integer.parseInt(s);
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject object = new me.TechsCode.dependencies.gson.JsonObject();
        object.addProperty("target", this.target.getKey());
        object.addProperty("issuer", this.issuer.getKey());
        if (this.server != null) {
            object.addProperty("server", this.server);
        }
        object.addProperty("time", this.time);
        object.addProperty("reason", this.reason);
        object.addProperty("seen", this.seen);
        object.addProperty("kick", this.kick);
        return null;
    }

    public void setState(JsonObject jsonObject, TechPlugin plugin) {
        StorageController controller = (StorageController)((Object)plugin);
        this.server = jsonObject.has("server") ? jsonObject.get("server").getAsString() : null;
        this.time = jsonObject.get("time").getAsLong();
        this.reason = jsonObject.get("reason").isJsonNull() ? "" : jsonObject.get("reason").getAsString();
        this.seen = jsonObject.get("seen").getAsBoolean();
        this.kick = jsonObject.has("kick") && jsonObject.get("kick").getAsBoolean();
    }

    public void onMount(TechPlugin techPlugin) {
    }
}

