/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.storage.types;

import com.google.gson.JsonObject;
import java.util.Optional;
import me.TechsCode.UltraPunishments.storage.types.PunishmentType;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.storage.Storable;

public class Template
extends Storable {
    private int id;
    private String name;
    private String reason;
    private PunishmentType type;
    private long duration;
    private String icon;

    public Template(int id, String name, String reason, PunishmentType type, long duration, String icon) {
        this.id = id;
        this.name = name;
        this.reason = reason;
        this.type = type;
        this.duration = duration;
        this.icon = icon;
    }

    public void remove() {
        this.destroy();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public PunishmentType getType() {
        return this.type;
    }

    public boolean isPermanent() {
        return this.duration == 0L;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setName(String name) {
        this.name = name;
        this.sync();
    }

    public void setType(PunishmentType type) {
        this.type = type;
        this.sync();
    }

    public void setReason(String reason) {
        this.reason = reason;
        this.sync();
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.sync();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.sync();
    }

    @Override
    public String getKey() {
        return this.id + "";
    }

    @Override
    public void setKey(String s) {
        this.id = Integer.parseInt(s);
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject object = new me.TechsCode.dependencies.gson.JsonObject();
        object.addProperty("name", this.name);
        object.addProperty("reason", this.reason);
        object.addProperty("type", this.type.name());
        object.addProperty("duration", this.duration);
        object.addProperty("icon", this.icon);
        return null;
    }

    public void setState(JsonObject jsonObject, TechPlugin plugin) {
        this.name = jsonObject.get("name").getAsString();
        this.reason = jsonObject.get("reason").isJsonNull() ? null : jsonObject.get("reason").getAsString();
        this.type = PunishmentType.valueOf(jsonObject.get("type").getAsString());
        this.duration = jsonObject.get("duration").getAsLong();
        if (jsonObject.get("icon") == null) {
            jsonObject.addProperty("icon", this.icon);
        }
        this.icon = jsonObject.get("icon").getAsString();
    }

    public void onMount(TechPlugin techPlugin) {
    }
}

