/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.storage.types;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.TechsCode.UltraPunishments.storage.StorageController;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.storage.Storable;
import me.TechsCode.base.storage.Stored;

public class Report
extends Storable {
    private int id;
    private Stored<IndexedPlayer> target;
    private Stored<IndexedPlayer> issuer;
    private String server;
    private long time;
    private String message;
    private String[] evidence;
    private boolean closed;

    public Report(int id, @Nonnull IndexedPlayer target, @Nullable IndexedPlayer issuer, String server, long time, String message, String[] evidence, boolean closed) {
        this.id = id;
        this.target = target.toStored();
        this.issuer = issuer != null ? issuer.toStored() : Stored.empty();
        this.server = server;
        this.time = time;
        this.message = message;
        this.evidence = evidence;
        this.closed = closed;
    }

    public boolean hasEvidence() {
        return this.evidence != null && this.evidence.length != 0;
    }

    public boolean hasMessage() {
        return this.message != null && !this.message.equals("null");
    }

    public Stored<IndexedPlayer> getTarget() {
        return this.target;
    }

    public Stored<IndexedPlayer> getIssuer() {
        return this.issuer;
    }

    public String getIssuerName() {
        return this.getIssuer().get().map(IndexedPlayer::getName).orElse("System");
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
        this.sync();
    }

    public void setMessage(String message) {
        this.message = message;
        this.sync();
    }

    public void setEvidence(String[] evidence) {
        this.evidence = evidence;
        this.sync();
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getEvidence() {
        return this.evidence;
    }

    public long getTimeCreated() {
        return this.time;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
        this.sync();
    }

    public void remove() {
        this.destroy();
    }

    @Override
    public String getKey() {
        return this.id + "";
    }

    @Override
    public void setKey(String s) {
        this.id = Integer.parseInt(s);
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject object = new me.TechsCode.dependencies.gson.JsonObject();
        object.addProperty("target", this.target.getKey());
        object.addProperty("issuer", this.issuer.getKey());
        object.addProperty("server", this.server);
        object.addProperty("time", this.time);
        object.addProperty("message", this.message);
        object.addProperty("evidence", this.evidence != null ? String.join((CharSequence)"<nl>", this.evidence).replace("\"", "") : null);
        object.addProperty("closed", this.closed);
        return null;
    }

    public void setState(JsonObject jsonObject, TechPlugin plugin) {
        StorageController controller = (StorageController)((Object)plugin);
        this.server = jsonObject.get("server").isJsonNull() ? "Local" : jsonObject.get("server").getAsString();
        this.time = jsonObject.get("time").getAsLong();
        this.message = jsonObject.get("message").isJsonNull() ? null : jsonObject.get("message").getAsString();
        this.evidence = jsonObject.get("evidence").isJsonNull() ? null : jsonObject.get("evidence").getAsString().split("<nl>");
        this.closed = jsonObject.get("closed").getAsBoolean();
    }

    public void onMount(TechPlugin techPlugin) {
    }
}

