/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.storage.types;

import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.TechsCode.UltraPunishments.storage.StorageController;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import me.TechsCode.UltraPunishments.storage.types.PunishmentType;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.networking.NServer;
import me.TechsCode.base.storage.Storable;
import me.TechsCode.base.storage.Stored;

public class Punishment
extends Storable {
    private int id;
    private Stored<IndexedPlayer> target;
    private Stored<IndexedPlayer> issuer;
    private String server;
    private long expiry;
    private long duration;
    private long date;
    private String reason;
    private PunishmentType type;

    public Punishment(int id, @Nonnull IndexedPlayer target, @Nullable IndexedPlayer issuer, @Nullable NServer server, long expiry, long duration, String reason, PunishmentType type, long date) {
        this.id = id;
        this.target = target.toStored();
        this.issuer = issuer != null ? issuer.toStored() : Stored.empty();
        this.server = server != null ? server.getName() : null;
        this.expiry = expiry;
        this.duration = duration;
        this.reason = reason;
        this.type = type;
        this.date = date;
    }

    public long getLeftDuration() {
        return this.expiry - System.currentTimeMillis();
    }

    public boolean isPermanent() {
        return this.expiry == 0L;
    }

    public boolean isExpired() {
        return !this.isPermanent() && this.expiry < System.currentTimeMillis();
    }

    public void remove() {
        this.destroy();
    }

    public boolean hasReason() {
        return this.getReason().isPresent();
    }

    public boolean hasIssuer() {
        return this.getIssuer().isPresent();
    }

    public Stored<IndexedPlayer> getTarget() {
        return this.target;
    }

    public Stored<IndexedPlayer> getIssuer() {
        return this.issuer;
    }

    public String getIssuerName() {
        return this.getIssuer().get().map(IndexedPlayer::getName).orElse("System");
    }

    public Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    public void setServer(String server) {
        this.server = server;
        this.sync();
    }

    public boolean isGlobal() {
        return this.server == null;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public long getFullDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.sync();
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public PunishmentType getType() {
        return this.type;
    }

    public long getDate() {
        return this.date;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
        this.sync();
    }

    @Override
    public String getKey() {
        return this.id + "";
    }

    @Override
    public void setKey(String s) {
        this.id = Integer.parseInt(s);
    }

    public void setReason(String reason) {
        this.reason = reason;
        this.sync();
    }

    public void setType(PunishmentType type) {
        this.type = type;
        this.sync();
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject object = new me.TechsCode.dependencies.gson.JsonObject();
        object.addProperty("target", this.target.getKey());
        object.addProperty("issuer", this.issuer.getKey());
        if (this.server != null) {
            object.addProperty("server", this.server);
        }
        object.addProperty("expiry", this.expiry);
        object.addProperty("duration", this.duration);
        object.addProperty("reason", this.reason);
        object.addProperty("type", this.type.name());
        object.addProperty("date", this.date);
        return null;
    }

    public void setState(JsonObject jsonObject, TechPlugin plugin) {
        StorageController controller = (StorageController)((Object)plugin);
        this.server = jsonObject.has("server") ? jsonObject.get("server").getAsString() : null;
        this.expiry = jsonObject.get("expiry").getAsLong();
        this.duration = jsonObject.get("duration").getAsLong();
        this.reason = jsonObject.get("reason").isJsonNull() ? null : jsonObject.get("reason").getAsString();
        this.type = PunishmentType.valueOf(jsonObject.get("type").getAsString());
        if (jsonObject.get("date") == null) {
            jsonObject.addProperty("date", (Number)this.date);
        }
        this.date = jsonObject.get("date").getAsLong();
        if (this.server != null && (this.server.equalsIgnoreCase("local") || this.server.equalsIgnoreCase("bungeecord"))) {
            this.server = null;
        }
    }

    public void onMount(TechPlugin techPlugin) {
    }
}

