/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments.storage.types;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.TechsCode.UltraPunishments.storage.StorageController;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.legacy.SkinTexture;
import me.TechsCode.base.storage.Storable;
import me.TechsCode.base.storage.Stored;

public class IndexedPlayer
extends Storable {
    private StorageController controller;
    private int id;
    private UUID uuid;
    private String playerName;
    private String ip;
    private boolean unpunishable;
    private SkinTexture skinTexture;

    public IndexedPlayer(int id, UUID uuid, String playerName, String ip, boolean unpunishable, SkinTexture skinTexture) {
        this.id = id;
        this.uuid = uuid;
        this.playerName = playerName;
        this.ip = ip;
        this.unpunishable = unpunishable;
        this.skinTexture = skinTexture;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.playerName;
    }

    public void setName(String playerName) {
        this.playerName = playerName;
        this.sync();
    }

    public Optional<String> getIP() {
        return Optional.of(this.ip);
    }

    public void setIP(String ip) {
        this.ip = ip;
        this.sync();
    }

    public boolean isUnpunishable() {
        return this.unpunishable;
    }

    public void setUnpunishable(boolean unpunishable) {
        this.unpunishable = unpunishable;
        this.sync();
    }

    public List<IndexedPlayer> getPlayersUnderSameIP() {
        return this.controller.getPlayerIndexStorage().get().stream().filter(index -> index.playerName.equals(this.playerName) || this.ip != null && index.ip != null && this.ip.equals(index.ip)).collect(Collectors.toList());
    }

    public void setSkinTexture(SkinTexture skinTexture) {
        if (this.skinTexture != null && this.skinTexture.getUrl().equalsIgnoreCase(skinTexture.getUrl())) {
            return;
        }
        this.skinTexture = skinTexture;
        this.sync();
    }

    public Optional<SkinTexture> getSkinTexture() {
        return Optional.ofNullable(this.skinTexture);
    }

    @Override
    public String getKey() {
        return this.id + "";
    }

    @Override
    public void setKey(String s) {
        this.id = Integer.parseInt(s);
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject object = new me.TechsCode.dependencies.gson.JsonObject();
        object.addProperty("uuid", this.uuid.toString());
        object.addProperty("playerName", this.playerName);
        if (this.ip != null) {
            object.addProperty("ip", this.ip);
        }
        object.addProperty("prevent", this.unpunishable);
        if (this.skinTexture != null) {
            object.addProperty("skull", this.skinTexture.toString());
        }
        return null;
    }

    @Override
    public void setState(JsonObject object, TechPlugin<?> plugin) {
    }

    public void onMount(TechPlugin techPlugin) {
        this.controller = (StorageController)((Object)techPlugin);
    }

    public Stored<IndexedPlayer> toStored() {
        return null;
    }
}

