/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments;

import com.google.gson.JsonObject;
import java.util.concurrent.TimeUnit;
import me.TechsCode.base.registry.RegistryStorable;

public class PublicRegistry
extends RegistryStorable {
    private boolean broadcastPunishments = true;
    private boolean announceReports = true;
    private boolean ipPunishments = true;
    private long reportCoolDown = TimeUnit.MINUTES.toSeconds(5L);

    public PublicRegistry() {
        super("public");
    }

    @Override
    public void setState(JsonObject jsonObject) {
        this.announceReports = jsonObject.get("announceReports").getAsBoolean();
        this.ipPunishments = jsonObject.get("ipPunishments").getAsBoolean();
        this.reportCoolDown = jsonObject.get("reportCooldown").getAsLong();
        if (jsonObject.get("broadcastPunishments") == null) {
            jsonObject.addProperty("broadcastPunishments", Boolean.valueOf(this.broadcastPunishments));
        }
        this.broadcastPunishments = jsonObject.get("broadcastPunishments").getAsBoolean();
    }

    @Override
    public JsonObject getState() {
        me.TechsCode.dependencies.gson.JsonObject jsonObject = new me.TechsCode.dependencies.gson.JsonObject();
        jsonObject.addProperty("announceReports", this.announceReports);
        jsonObject.addProperty("ipPunishments", this.ipPunishments);
        jsonObject.addProperty("reportCooldown", this.reportCoolDown);
        jsonObject.addProperty("broadcastPunishments", this.broadcastPunishments);
        return null;
    }

    public boolean isAnnouncingReports() {
        return this.announceReports;
    }

    public void setAnnouncingReports(boolean announceReports) {
        this.announceReports = announceReports;
        this.sync();
    }

    public boolean isBroadcastingPunishments() {
        return this.broadcastPunishments;
    }

    public void setBroadcastingPunishments(boolean broadcastPunishments) {
        this.broadcastPunishments = broadcastPunishments;
        this.sync();
    }

    public boolean isIpPunishments() {
        return this.ipPunishments;
    }

    public void setIpPunishments(boolean ipPunishments) {
        this.ipPunishments = ipPunishments;
        this.sync();
    }

    public long getReportCooldown() {
        return this.reportCoolDown;
    }

    public void setReportCooldown(long reportCooldown) {
        this.reportCoolDown = reportCooldown;
        this.sync();
    }
}

