/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments;

import java.util.Optional;
import java.util.UUID;
import me.TechsCode.UltraPunishments.UltraPunishments;
import me.TechsCode.UltraPunishments.storage.PlayerIndexStorage;
import me.TechsCode.UltraPunishments.storage.types.IndexedPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class PlayerRegistrationManager
implements Listener {
    private UltraPunishments plugin;
    private PlayerIndexStorage playerIndexStorage;

    public PlayerRegistrationManager(UltraPunishments plugin, PlayerIndexStorage playerIndexStorage) {
        this.plugin = plugin;
        this.playerIndexStorage = playerIndexStorage;
        for (Player all : Bukkit.getOnlinePlayers()) {
            this.addPlayerIndex(all, all.getAddress().getHostName());
        }
    }

    private void addPlayerIndex(Player p, String ip) {
        UUID uuid = p.getUniqueId();
        String playerName = p.getName();
        Optional<IndexedPlayer> search = this.plugin.getPlayerIndexes().get(p);
        if (!search.isPresent()) {
            this.playerIndexStorage.registerPlayer(uuid, playerName, ip);
        } else {
            IndexedPlayer player = search.get();
            if (!player.getName().equals(playerName)) {
                player.setName(playerName);
            }
            if (!player.getIP().isPresent() || !player.getIP().get().equals(ip)) {
                player.setIP(ip);
            }
        }
    }

    @EventHandler
    public void addIndex(PlayerLoginEvent e) {
    }
}

