/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.UltraPunishments;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.TechsCode.UltraPunishments.APIEndpoint;
import me.TechsCode.base.visual.Text;

public enum KickFormat {
    TEMP_BAN(new String[]{"\u00a77You are \u00a7ctemporarily \u00a77banned by \u00a7b{Issuer} \u00a77from this Server", "\u00a77the Ban will expire in \u00a76{Time}", "", "\u00a7f{Reason}", "", "\u00a77Id: \u00a7f{Id}\u00a77, Date: \u00a7e{PunishmentDate} {PunishmentTime}"}, "{Issuer}", "{Reason}", "{Time}", "{Id}", "{PunishmentDate}", "{PunishmentTime}"),
    PERMA_BAN(new String[]{"\u00a77You are \u00a7cpermanently \u00a77banned by \u00a7b{Issuer} \u00a77from this Server", "", "\u00a7f{Reason}", "", "\u00a77Id: \u00a7f{Id}\u00a77, Date: \u00a7e{PunishmentDate} {PunishmentTime}"}, "{Issuer}", "{Reason}", "{Id}", "{PunishmentDate}", "{PunishmentTime}"),
    WARNING(new String[]{"\u00a77You got warned by \u00a7b{Issuer}:", "\u00a7f{Reason}"}, "{Issuer}", "{Reason}", "{Id}"),
    KICK(new String[]{"\u00a77You got kicked by \u00a7b{Issuer}:", "\u00a7f{Reason}"}, "{Issuer}", "{Reason}");

    private final String[] defaultFormat;
    private final String[] placeholders;

    private KickFormat(String[] defaultFormat, String ... placeholders) {
        this.defaultFormat = defaultFormat;
        this.placeholders = placeholders;
    }

    public String[] getPlaceholders() {
        return this.placeholders;
    }

    public String getKickMessage(APIEndpoint plugin, String ... placeholderValues) {
        List<String> format = Arrays.asList(plugin.getFormatRegistry().getFormat(this));
        int i = 0;
        for (String placeholder : this.getPlaceholders()) {
            String value = placeholderValues[i];
            format = format.stream().filter(Objects::nonNull).map(line -> line.replace(placeholder, value)).collect(Collectors.toList());
            ++i;
        }
        return Text.color(String.join((CharSequence)"\n", format));
    }

    public String[] getDefaultFormat() {
        return this.defaultFormat;
    }

    public static String dateString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyy");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String timeString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
        String timeString = formatter.format(date);
        return timeString;
    }
}

