/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.config.PluginConfig;
import org.bukkit.scheduler.BukkitRunnable;

public class DatabaseConnection {
    private static KeepAlive keepAlive;
    private static DatabaseConnection databaseConnection;
    private static Connection connection;
    private String host = PluginConfig.getHost();
    private int port = Integer.parseInt(PluginConfig.getPort());
    private String database = PluginConfig.getDatabase();
    private String username = PluginConfig.getUsername();
    private String password = PluginConfig.getPassword();
    private boolean ssl = PluginConfig.isSsl();

    private DatabaseConnection() {
        keepAlive = new KeepAlive();
    }

    public static DatabaseConnection getInstance() {
        return databaseConnection;
    }

    public static void shutdown() {
        keepAlive.cancel();
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection() throws SQLException, ClassNotFoundException {
        DatabaseConnection databaseConnection = this;
        synchronized (databaseConnection) {
            if (connection != null && !connection.isClosed()) {
                return;
            }
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=" + this.ssl, this.username, this.password);
        }
    }

    public Connection getConnection() {
        return connection;
    }

    static {
        databaseConnection = new DatabaseConnection();
    }

    private class KeepAlive
    extends BukkitRunnable {
        private String query = "SELECT 1 FROM PPlot;";

        public KeepAlive() {
            this.runTaskTimerAsynchronously(PlayerPlot.getPlugin(), 600L, 600L);
        }

        public void run() {
            try {
                DatabaseConnection.this.openConnection();
                Statement statement = connection.createStatement();
                statement.executeQuery(this.query);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

