/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util.border;

import me.sword7.playerplot.PlayerPlot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerPusher
extends BukkitRunnable {
    private static final double SPEED = 0.025;
    private Player player;
    private World world;
    private double x;
    private double z;
    private double bx1;
    private double bz1;
    private double bx2;
    private double bz2;
    private boolean cancelled = false;

    public PlayerPusher(Player player, double x, double z, double size) {
        double rad = size / 2.0;
        this.x = x;
        this.z = z;
        this.bx1 = x - rad;
        this.bz1 = z - rad;
        this.bx2 = x + rad;
        this.bz2 = z + rad;
        this.player = player;
        this.world = player.getWorld();
        this.player = player;
        this.runTaskTimer(PlayerPlot.getPlugin(), 0L, 5L);
    }

    public void run() {
        Location playerLoc = this.player.getLocation();
        double px = playerLoc.getX();
        double pz = playerLoc.getZ();
        if (px - this.bx1 <= -0.2 || this.bx2 - px <= -0.2) {
            Location towards = new Location(this.world, this.x, playerLoc.getY(), playerLoc.getZ(), 0.0f, 0.0f);
            this.player.setVelocity(towards.subtract(playerLoc).toVector().multiply(0.025));
        } else if (pz - this.bz1 <= -0.2 || this.bz2 - pz < -0.2) {
            Location towards = new Location(this.world, playerLoc.getX(), playerLoc.getY(), this.z, 0.0f, 0.0f);
            this.player.setVelocity(towards.subtract(playerLoc).toVector().multiply(0.025));
        } else {
            this.cancel();
        }
    }

    public void cancel() {
        super.cancel();
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

