/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import java.util.UUID;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.util.Friend;
import me.sword7.playerplot.util.PlotPoint;
import org.bukkit.ChatColor;

public class PlotUtil {
    public static int parseAmount(String string) {
        try {
            int amt = Integer.parseInt(string);
            if (amt < 0) {
                amt = 0;
            }
            return amt;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static int getUpgradeLength(int relSize) {
        int unitSideLength = PluginConfig.getPlotUnitSideLength();
        int unitSquared = unitSideLength * unitSideLength;
        int newLength = (int)Math.round(Math.sqrt(Math.round(unitSquared * ++relSize)));
        return newLength;
    }

    public static int getDowngradeLength(int relSize) {
        int unitSideLength = PluginConfig.getPlotUnitSideLength();
        int unitSquared = unitSideLength * unitSideLength;
        int newLength = (int)Math.round(Math.sqrt(Math.round(unitSquared * --relSize)));
        return newLength;
    }

    public static String getListString(Plot plot) {
        int length = plot.getSideLength();
        PlotPoint center = plot.getCenter();
        String displayString = ChatColor.DARK_PURPLE + plot.getName();
        displayString = displayString + ChatColor.LIGHT_PURPLE + " (" + length + "x" + length + ")[" + ChatColor.AQUA + plot.getComponents() + ChatColor.LIGHT_PURPLE + "] ";
        displayString = displayString + ChatColor.GRAY + "(" + plot.getWorld() + ", " + center.getX() + ", " + center.getZ() + ")";
        return displayString;
    }

    public static String getFListString(Plot plot) {
        String displayString = ChatColor.DARK_PURPLE + plot.getName() + ChatColor.GRAY + " - " + plot.getOwnerName();
        return displayString;
    }

    public static String getFriendsAsString(Plot plot) {
        Object friends = "";
        for (Friend friend : plot.getFriends()) {
            friends = (String)friends + ", " + friend.getName();
        }
        if (((String)friends).length() > 2) {
            return ((String)friends).substring(2);
        }
        return "-";
    }

    public static String getDefaultName(UUID playerID) {
        String plotBase = "plot_";
        int num = 1;
        String attempt = plotBase + num;
        while (PlotCache.getPlayerPlot(playerID, attempt) != null) {
            attempt = plotBase + ++num;
        }
        return attempt;
    }
}

