/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import me.sword7.playerplot.util.LocationParts;
import org.bukkit.Location;
import org.bukkit.World;

public class PlotPoint {
    private final int x;
    private final int z;

    public PlotPoint(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public PlotPoint[] getCorners(int sideLength) {
        PlotPoint[] corners;
        corners = new PlotPoint[]{this.getMinCorner(sideLength), this.getMaxCorner(sideLength), new PlotPoint(corners[0].getX(), corners[1].getZ()), new PlotPoint(corners[1].getX(), corners[0].getZ())};
        return corners;
    }

    public PlotPoint getMaxCorner(int sideLength) {
        int effectiveHalfLength = sideLength % 2 == 0 ? sideLength / 2 : (sideLength - 1) / 2;
        return new PlotPoint(this.x + effectiveHalfLength, this.z + effectiveHalfLength);
    }

    public PlotPoint getMinCorner(int sideLength) {
        int effectiveHalfLength = sideLength % 2 == 0 ? sideLength / 2 - 1 : (sideLength - 1) / 2;
        return new PlotPoint(this.x - effectiveHalfLength, this.z - effectiveHalfLength);
    }

    public Location asLocation(World world) {
        return new Location(world, (double)this.x, 64.0, (double)this.z, 0.0f, 0.0f);
    }

    public LocationParts asLocationParts(String world) {
        return new LocationParts(world, this.x, 64.0, this.z, 0.0f, 0.0f);
    }

    public static PlotPoint fromLocation(Location location) {
        return new PlotPoint(location.getBlockX(), location.getBlockZ());
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

