/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationParts {
    private Location location;
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public LocationParts(Location location) {
        this.location = location;
        this.worldName = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
    }

    public LocationParts(String worldName, double x, double y, double z, float yaw, float pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Location getLocation() {
        World world;
        if (this.location == null && (world = Bukkit.getWorld((String)this.worldName)) != null) {
            this.location = new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
        }
        return this.location;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public String toString() {
        return this.worldName + "_" + this.x + "_" + this.y + "_" + this.z + "_" + this.yaw + "_" + this.pitch;
    }

    public boolean equals(Object o) {
        if (o instanceof Location) {
            Location l = (Location)o;
            return this.worldName.equals(l.getWorld().getName()) && this.x == l.getX() && this.y == l.getY() && this.z == l.getZ() && this.yaw == this.location.getYaw() && this.pitch == this.location.getPitch();
        }
        if (o instanceof LocationParts) {
            LocationParts l = (LocationParts)o;
            return this.worldName.equals(l.worldName) && this.x == l.x && this.y == l.y && this.z == l.z && this.yaw == l.yaw && this.pitch == l.pitch;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.worldName).append(this.x).append(this.y).append(this.z).append(this.yaw).append(this.pitch).toHashCode();
    }

    public static LocationParts parseParts(String string) {
        try {
            String[] parts = string.split("_");
            int partsLength = parts.length;
            Object worldName = parts[0];
            for (int i = 1; i < partsLength - 5; ++i) {
                worldName = (String)worldName + "_" + parts[i];
            }
            double x = Double.parseDouble(parts[partsLength - 5]);
            double y = Double.parseDouble(parts[partsLength - 4]);
            double z = Double.parseDouble(parts[partsLength - 3]);
            float yaw = Float.parseFloat(parts[partsLength - 2]);
            float pitch = Float.parseFloat(parts[partsLength - 1]);
            return new LocationParts((String)worldName, x, y, z, yaw, pitch);
        }
        catch (Exception e) {
            return null;
        }
    }
}

