/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import java.util.List;
import me.sword7.playerplot.config.Language;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class InfoList {
    private final String title;
    private final List<String> items;
    private final int pageItemCount;

    public InfoList(String title, List<String> items, int pageItemCount) {
        this.title = title;
        this.items = items;
        this.pageItemCount = pageItemCount;
    }

    public void displayTo(CommandSender sender, int page) {
        int startIndex;
        if (page < 1) {
            page = 1;
        }
        sender.sendMessage(this.title);
        sender.sendMessage(ChatColor.DARK_GRAY + "> " + Language.LABEL_PAGE.toString().toLowerCase() + " " + page);
        for (int i = startIndex = (page - 1) * this.pageItemCount; i < startIndex + this.pageItemCount; ++i) {
            int num = i + 1;
            String prefix = num + ". ";
            if (i < this.items.size()) {
                sender.sendMessage(prefix + this.items.get(i));
                continue;
            }
            sender.sendMessage(prefix + "-");
        }
    }
}

