/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.util.PlotPoint;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Location;

public class GridZone {
    private static int gridGroupAmount = PluginConfig.getPlotUnitSideLength() * 16;
    private int x;
    private int z;

    public GridZone(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static final GridZone fromLocation(Location location) {
        return GridZone.from(location.getBlockX(), location.getBlockZ());
    }

    public static final GridZone fromPlotPoint(PlotPoint plotPoint) {
        return GridZone.from(plotPoint.getX(), plotPoint.getZ());
    }

    public static final GridZone from(int blockX, int blockZ) {
        int offsetX = blockX < 0 ? -1 : 0;
        int x = blockX / gridGroupAmount + offsetX;
        int offsetZ = blockZ < 0 ? -1 : 0;
        int z = blockZ / gridGroupAmount + offsetZ;
        return new GridZone(x, z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o instanceof GridZone) {
            GridZone gridZone = (GridZone)o;
            return this.x == gridZone.x && this.z == gridZone.z;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.x).append(this.z).toHashCode();
    }
}

