/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import java.util.UUID;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Friend {
    private UUID uuid;
    private String name;

    public Friend(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public Friend(Player player) {
        this.uuid = player.getUniqueId();
        this.name = player.getName();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return this.uuid.equals(uuid);
        }
        if (o instanceof String) {
            String string = (String)o;
            return this.name.equalsIgnoreCase(string);
        }
        if (o instanceof Friend) {
            Friend friend = (Friend)o;
            return this.uuid.equals(friend.getUuid()) && this.name.equalsIgnoreCase(friend.getName());
        }
        if (o instanceof Player) {
            Player player = (Player)o;
            return this.uuid.equals(player.getUniqueId()) && this.name.equalsIgnoreCase(player.getName());
        }
        if (o instanceof OfflinePlayer) {
            OfflinePlayer offlinePlayer = (OfflinePlayer)o;
            return this.uuid.equals(offlinePlayer.getUniqueId()) && this.name.equalsIgnoreCase(offlinePlayer.getName());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 29).append((Object)this.uuid).append((Object)this.name).toHashCode();
    }
}

