/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.plotdeed.PlotDeedType;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;

public class AutoCompleteListener
implements Listener {
    private static final List<String> SCAN_COMPLETIONS = Collections.singletonList("-l");
    private static final List<String> PLOT_COMPLETIONS = ImmutableList.builder().add((Object)"help").add((Object)"scan").add((Object)"claim").add((Object)"list").add((Object)"flist").add((Object)"rename").add((Object)"free").add((Object)"info").add((Object)"trust").add((Object)"untrust").add((Object)"upgrade").add((Object)"downgrade").add((Object)"setcenter").add((Object)"setspawn").build();
    private static final List<String> PLUGIN_COMPLETIONS = ImmutableList.builder().add((Object)"help").add((Object)"info").build();
    private static final List<String> PLOT_ACTION_COMPLETIONS = ImmutableList.builder().add((Object)"rename").add((Object)"free").add((Object)"info").add((Object)"trust").add((Object)"untrust").add((Object)"upgrade").add((Object)"downgrade").add((Object)"setcenter").build();
    public static final List<String> PLOT_DEED_COMPLETIONS = AutoCompleteListener.buildPlotDeedTypes();

    public AutoCompleteListener() {
        Plugin plugin = PlayerPlot.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onComplete(TabCompleteEvent e) {
        if (e.getSender() instanceof Player) {
            String rootCommand = PluginConfig.getRootCommand();
            String buffer = e.getBuffer();
            Player player = (Player)e.getSender();
            if (buffer.startsWith("/playerplot ")) {
                int args = this.numberOfFullArgs(buffer);
                if (args == 0) {
                    String root = "/playerplot";
                    ArrayList<String> completions = new ArrayList<String>();
                    completions.addAll(PLUGIN_COMPLETIONS);
                    if (Permissions.canReload((CommandSender)player)) {
                        completions.add("reload");
                    }
                    e.setCompletions(this.getRefinedCompletions(root, buffer, completions));
                } else {
                    e.setCompletions(Collections.EMPTY_LIST);
                }
            } else if (buffer.startsWith("/" + rootCommand + " @")) {
                int args = this.numberOfFullArgs(buffer);
                if (args == 0) {
                    String root = "/" + rootCommand;
                    e.setCompletions(this.getRefinedCompletions(root, buffer, this.getAtPlotNames(player)));
                } else if (args == 1) {
                    String root = "/" + rootCommand + " " + this.getArg(buffer, 0);
                    e.setCompletions(this.getRefinedCompletions(root, buffer, PLOT_ACTION_COMPLETIONS));
                } else if (args == 2) {
                    String base = "/" + rootCommand + " " + this.getArg(buffer, 0);
                    if (buffer.startsWith(base + " trust ")) {
                        String root = base + " trust";
                        e.setCompletions(this.getRefinedCompletions(root, buffer, AutoCompleteListener.onlineCompletions(player)));
                    } else if (buffer.startsWith(base + " untrust ")) {
                        String root = base + " untrust";
                        e.setCompletions(this.getRefinedCompletions(root, buffer, AutoCompleteListener.onlineCompletions(player)));
                    } else if (buffer.startsWith(base + " rename ")) {
                        e.setCompletions(Collections.EMPTY_LIST);
                    }
                }
            } else if (buffer.startsWith("/" + rootCommand + " ")) {
                int args = this.numberOfFullArgs(buffer);
                if (args == 0) {
                    String root = "/" + rootCommand;
                    e.setCompletions(this.getRefinedCompletions(root, buffer, PLOT_COMPLETIONS));
                } else if (args == 1) {
                    String base = "/" + rootCommand;
                    if (buffer.startsWith(base + " trust ")) {
                        String root = base + " trust";
                        e.setCompletions(this.getRefinedCompletions(root, buffer, AutoCompleteListener.onlineCompletions(player)));
                    } else if (buffer.startsWith(base + " untrust ")) {
                        String root = base + " untrust";
                        e.setCompletions(this.getRefinedCompletions(root, buffer, AutoCompleteListener.onlineCompletions(player)));
                    } else if (buffer.startsWith(base + " rename ") || buffer.startsWith(base + " claim ")) {
                        e.setCompletions(Collections.EMPTY_LIST);
                    } else if (buffer.startsWith(base + " scan ")) {
                        String root = base + " scan";
                        e.setCompletions(this.getRefinedCompletions(root, buffer, SCAN_COMPLETIONS));
                    }
                }
            } else if (buffer.startsWith("/toplot ")) {
                String root = "/toplot";
                e.setCompletions(this.getRefinedCompletions(root, buffer, this.getPlotNames(player)));
            } else if (buffer.startsWith("/plotdeed")) {
                int args = this.numberOfFullArgs(buffer);
                if (args == 0) {
                    String root = "/plotdeed";
                    ArrayList<String> completions = new ArrayList<String>();
                    completions.addAll(PLOT_DEED_COMPLETIONS);
                    completions.add("list");
                    e.setCompletions(this.getRefinedCompletions(root, buffer, completions));
                } else if (args == 1) {
                    String root = "/plotdeed " + this.getArg(buffer, 0);
                    e.setCompletions(this.getRefinedCompletions(root, buffer, AutoCompleteListener.onlineCompletions()));
                } else {
                    e.setCompletions(Collections.EMPTY_LIST);
                }
            } else if (buffer.startsWith("/writedeed") || buffer.startsWith("/delplot ") || buffer.startsWith("/allplots ")) {
                e.setCompletions(Collections.EMPTY_LIST);
            }
        }
    }

    private List<String> getRefinedCompletions(String root, String buffer, List<String> completions) {
        if (buffer.equalsIgnoreCase(root + " ")) {
            return completions;
        }
        ArrayList<String> refinedCompletions = new ArrayList<String>();
        String bufferFromRoot = buffer.split(root + " ")[1];
        for (String completion : completions) {
            if (bufferFromRoot.length() >= completion.length() || !completion.substring(0, bufferFromRoot.length()).equalsIgnoreCase(bufferFromRoot)) continue;
            refinedCompletions.add(completion);
        }
        return refinedCompletions;
    }

    private int numberOfFullArgs(String buffer) {
        int lastNotCompletedPenalty = this.endsInSpace(buffer) ? 0 : -1;
        return buffer.split(" ").length - 1 + lastNotCompletedPenalty;
    }

    private boolean endsInSpace(String buffer) {
        return ' ' == buffer.charAt(buffer.length() - 1);
    }

    private String getArg(String buffer, int arg) {
        return buffer.split(" ")[arg + 1];
    }

    private List<String> getAtPlotNames(Player player) {
        ArrayList<String> plotNames = new ArrayList<String>();
        for (Plot plot : PlotCache.getPlayerPlots(player.getUniqueId())) {
            plotNames.add("@" + plot.getName());
        }
        plotNames.add("@" + Language.MISC_HERE);
        return plotNames;
    }

    private List<String> getPlotNames(Player player) {
        ArrayList<String> plotNames = new ArrayList<String>();
        for (Plot plot : PlotCache.getPlayerPlots(player.getUniqueId())) {
            plotNames.add(plot.getName());
        }
        return plotNames;
    }

    private static List<String> onlineCompletions(Player player) {
        ArrayList<String> onlinePlayerName = new ArrayList<String>();
        for (Player oPlayer : Bukkit.getOnlinePlayers()) {
            if (oPlayer == player) continue;
            onlinePlayerName.add(oPlayer.getName());
        }
        return onlinePlayerName;
    }

    private static List<String> onlineCompletions() {
        ArrayList<String> onlinePlayerName = new ArrayList<String>();
        for (Player oPlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayerName.add(oPlayer.getName());
        }
        return onlinePlayerName;
    }

    public static List<String> buildPlotDeedTypes() {
        ArrayList<String> plotDeedTypes = new ArrayList<String>();
        for (PlotDeedType plotDeedType : PlotDeedType.values()) {
            plotDeedTypes.add(plotDeedType.toString());
        }
        return plotDeedTypes;
    }
}

