/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.user;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.user.UserData;
import me.sword7.playerplot.user.UserDatabase;
import me.sword7.playerplot.user.UserFlatFile;
import me.sword7.playerplot.util.PermInfo;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class UserCache
implements Listener {
    private static Map<UUID, UserData> userToData = new HashMap<UUID, UserData>();
    private static HashMap<UUID, PermInfo> userToPerms = new HashMap();
    private static UserFlatFile userFlatFile = new UserFlatFile();
    private static boolean usingDatabase = PluginConfig.isUsingDatabase();
    private static UserDatabase database = usingDatabase ? new UserDatabase() : null;

    public UserCache() {
        Plugin plugin = PlayerPlot.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.load();
    }

    public static boolean hasData(UUID playerID) {
        return userToData.containsKey(playerID) && userToData.get(playerID) != null;
    }

    public static UserData getData(UUID playerID) {
        return userToData.get(playerID);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        UUID playerID = player.getUniqueId();
        userToPerms.put(playerID, Permissions.getPermInfo(player));
        UserCache.cache(playerID);
        UserCache.processNameChange(player);
    }

    private static void processNameChange(Player player) {
        Plot plot;
        List<Plot> plotList = PlotCache.getPlayerPlots(player.getUniqueId());
        if (plotList.size() > 0 && !(plot = plotList.get(0)).getOwnerName().equalsIgnoreCase(player.getName())) {
            String ownerName = player.getName();
            plot.setOwnerName(ownerName);
            for (int i = 1; i < plotList.size(); ++i) {
                plotList.get(i).setOwnerName(ownerName);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent e) {
        UUID playerID = e.getPlayer().getUniqueId();
        userToPerms.remove(playerID);
        UserData userData = userToData.get(playerID);
        if (userData != null) {
            UserCache.forget(playerID);
        }
    }

    private void load() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID playerID = player.getUniqueId();
            userToPerms.put(playerID, Permissions.getPermInfo(player));
            UserCache.cache(playerID);
        }
    }

    public static void shutdown() {
        UserCache.save();
        userToPerms.clear();
        userToData.clear();
    }

    public static void save() {
        for (UUID playerID : userToData.keySet()) {
            UserData userData = userToData.get(playerID);
            if (usingDatabase) {
                database.storeUserSync(playerID, userData);
                continue;
            }
            userFlatFile.store(playerID, userData);
        }
    }

    public static void cache(UUID playerID) {
        if (usingDatabase) {
            database.fetchUserDataAsync(playerID, userData -> {
                if (userData != null) {
                    userToData.put(playerID, (UserData)userData);
                }
            });
        } else {
            UserData userData2 = userFlatFile.fetch(playerID);
            if (userData2 != null) {
                userToData.put(playerID, userData2);
            }
        }
    }

    public static void forget(UUID playerID) {
        UserData userData = userToData.get(playerID);
        if (usingDatabase) {
            database.storeUserAsync(playerID, userData);
        } else {
            userFlatFile.store(playerID, userData);
        }
        userToData.remove(playerID);
    }

    public static PermInfo getPerms(UUID playerID) {
        return userToPerms.get(playerID);
    }
}

