/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plotdeed;

import java.util.UUID;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plotdeed.PlotDeed;
import me.sword7.playerplot.user.UserCache;
import me.sword7.playerplot.user.UserData;
import me.sword7.playerplot.util.PermInfo;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlotDeedListener
implements Listener {
    public PlotDeedListener() {
        Plugin plugin = PlayerPlot.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent e) {
        ItemStack itemStack;
        if ((e.getAction() == Action.RIGHT_CLICK_BLOCK || e.getAction() == Action.RIGHT_CLICK_AIR) && PlotDeed.isPlotDeed(itemStack = e.getItem())) {
            e.setCancelled(true);
            Player player = e.getPlayer();
            UUID playerID = player.getUniqueId();
            if (UserCache.hasData(playerID)) {
                UserData userData = UserCache.getData(playerID);
                PermInfo permInfo = UserCache.getPerms(playerID);
                int availablePlots = PluginConfig.getStartingPlotNum() + userData.getUnlockedPlots() + permInfo.getPlotBonus();
                if (availablePlots < permInfo.getPlotMax()) {
                    userData.unlockPlot();
                    player.sendMessage(ChatColor.LIGHT_PURPLE + "+1 plot");
                    player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 2.0f, 1.0f);
                    itemStack.setAmount(itemStack.getAmount() - 1);
                } else {
                    player.sendMessage(ChatColor.RED + Language.WARN_PLOT_MAX.toString());
                }
            }
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        for (ItemStack itemStack : e.getInventory()) {
            if (!PlotDeed.isPlotDeed(itemStack)) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        for (ItemStack itemStack : e.getInventory()) {
            if (!PlotDeed.isPlotDeed(itemStack)) continue;
            e.getInventory().setItem(0, new ItemStack(Material.AIR, 1));
            return;
        }
    }
}

