/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plotdeed;

import java.util.HashMap;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.plotdeed.ILoot;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandLoot
implements CommandExecutor {
    private ILoot loot;

    public CommandLoot(ILoot loot) {
        this.loot = loot;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (Permissions.canSummon(sender)) {
            if (args.length == 0) {
                if (sender instanceof Player) {
                    this.giveLoot((Player)sender, this.loot.getDefault(), 1);
                } else {
                    this.sendHelp(sender);
                }
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("list")) {
                    this.showTypeList(sender);
                } else if (this.isInt(args[0])) {
                    int amount = this.getCleanedAmount(args[0]);
                    if (sender instanceof Player) {
                        this.giveLoot((Player)sender, this.loot.getDefault(), amount);
                    } else {
                        this.sendHelp(sender);
                    }
                } else {
                    ItemStack itemStack;
                    try {
                        itemStack = this.loot.valueOf(args[0].toUpperCase());
                    }
                    catch (Exception e) {
                        sender.sendMessage(ChatColor.RED + Language.WARN_UNKNOWN_TYPE.toString());
                        return false;
                    }
                    if (sender instanceof Player) {
                        this.giveLoot((Player)sender, itemStack, 1);
                    } else {
                        this.sendHelp(sender);
                    }
                }
            } else if (args.length == 2) {
                ItemStack itemStack;
                try {
                    itemStack = this.loot.valueOf(args[0].toUpperCase());
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + Language.WARN_UNKNOWN_TYPE.toString());
                    return false;
                }
                if (this.isInt(args[1])) {
                    int amount = this.getCleanedAmount(args[1]);
                    if (sender instanceof Player) {
                        this.giveLoot((Player)sender, itemStack, amount);
                    } else {
                        this.sendHelp(sender);
                    }
                } else {
                    Player player = Bukkit.getServer().getPlayer(args[1]);
                    if (player != null) {
                        this.giveLoot(player, itemStack, 1);
                        sender.sendMessage(ChatColor.LIGHT_PURPLE + Language.SUCCESS_ITEMS_SENT.fromPlayerAndAmount(player.getName(), 1));
                    } else {
                        player.sendMessage(ChatColor.RED + Language.WARN_PLAYER_NOT_FOUND.fromPlayer(player.getName()));
                    }
                }
            } else if (args.length >= 3) {
                ItemStack itemStack;
                try {
                    itemStack = this.loot.valueOf(args[0].toUpperCase());
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + Language.WARN_UNKNOWN_TYPE.toString());
                    return false;
                }
                Player player = Bukkit.getServer().getPlayer(args[1]);
                if (player != null) {
                    int amount = this.isInt(args[2]) ? this.getCleanedAmount(args[2]) : 1;
                    this.giveLoot(player, itemStack, amount);
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + Language.SUCCESS_ITEMS_SENT.fromPlayerAndAmount(player.getName(), amount));
                } else {
                    player.sendMessage(ChatColor.RED + Language.WARN_PLAYER_NOT_FOUND.fromPlayer(player.getName()));
                }
            }
        } else {
            sender.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
        return false;
    }

    private void showTypeList(CommandSender sender) {
        sender.sendMessage(ChatColor.LIGHT_PURPLE + this.loot.getListLabel() + ":");
        for (String type : this.loot.getLootTypes()) {
            sender.sendMessage(ChatColor.GRAY + "- " + type);
        }
    }

    private int getCleanedAmount(String validIntString) {
        int amount = Integer.parseInt(validIntString);
        if (amount < 0) {
            amount = 0;
        }
        if (amount > 255) {
            amount = 255;
        }
        return amount;
    }

    private void giveLoot(Player player, ItemStack itemStack, int amount) {
        if (amount > 0) {
            itemStack.setAmount(amount);
            HashMap overflow = player.getInventory().addItem(new ItemStack[]{itemStack});
            for (ItemStack overItem : overflow.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), overItem);
            }
        }
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + Language.MISC_FORMAT.fromFormat("/" + this.loot.getRoot() + " [" + this.loot.getType() + "] [" + Language.ARG_PLAYER + "] [" + Language.ARG_AMOUNT + "]"));
    }

    private boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

