/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.UUID;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.util.PlotPoint;
import org.bukkit.Location;

public class Validation {
    public static NameStatus cleanName(String name, UUID playerID) {
        if (!name.matches("^[a-zA-Z0-9\\_\\-]+$")) {
            return NameStatus.SPECIAL_CHARACTERS;
        }
        if (name.length() > 20) {
            return NameStatus.TOO_LONG;
        }
        if (name.toLowerCase().equals(Language.MISC_HERE.toString())) {
            return NameStatus.RESERVED_NAME;
        }
        if (PlotCache.getPlayerPlot(playerID, name) != null) {
            return NameStatus.NAME_TAKEN;
        }
        return NameStatus.VALID;
    }

    public static RegionStatus canPlotBeRegisteredAt(Location center, int sideLength, UUID selfID) {
        if (!PluginConfig.isAllowedPlotWorld(center.getWorld())) {
            return RegionStatus.INVALID_WORLD;
        }
        if (Validation.overlapsPlayerPlot(center, sideLength, selfID)) {
            return RegionStatus.REGION_OCCUPIED;
        }
        if (Validation.overlapsTownisPlot(center, sideLength)) {
            return RegionStatus.REGION_OCCUPIED;
        }
        return RegionStatus.VALID;
    }

    public static RegionStatus canPlotBeUpgradedAt(String world, PlotPoint center, int sideLength, UUID selfID) {
        Location centerLoc = center.asLocationParts(world).getLocation();
        if (centerLoc != null) {
            if (!PluginConfig.isAllowedPlotWorld(centerLoc.getWorld())) {
                return RegionStatus.INVALID_WORLD;
            }
            if (Validation.overlapsPlayerPlot(centerLoc, sideLength, selfID)) {
                return RegionStatus.REGION_OCCUPIED;
            }
            if (Validation.overlapsTownisPlot(centerLoc, sideLength)) {
                return RegionStatus.REGION_OCCUPIED;
            }
            return RegionStatus.VALID;
        }
        return RegionStatus.INVALID_WORLD;
    }

    public static boolean overlapsPlayerPlot(Location center, int sideLength, UUID selfID) {
        for (Plot plot : PlotCache.getPlotsNear(center, sideLength)) {
            PlotPoint[] smallerPoints;
            if (plot.getID().equals(selfID)) continue;
            boolean existingPlotBigger = plot.getSideLength() >= sideLength;
            PlotPoint[] existingCorners = plot.getCorners();
            PlotPoint[] targetCorners = PlotPoint.fromLocation(center).getCorners(sideLength);
            PlotPoint[] biggerPoints = existingPlotBigger ? existingCorners : targetCorners;
            if (!Validation.overlaps(biggerPoints, smallerPoints = existingPlotBigger ? targetCorners : existingCorners)) continue;
            return true;
        }
        return false;
    }

    private static boolean overlapsTownisPlot(Location center, int sideLength) {
        return false;
    }

    private static boolean overlaps(PlotPoint[] biggerPlot, PlotPoint[] smallerPlot) {
        boolean overlaps = false;
        for (PlotPoint plotCorner : smallerPlot) {
            if (!Validation.regionContainsPoint(biggerPlot, plotCorner)) continue;
            overlaps = true;
            break;
        }
        return overlaps;
    }

    private static boolean regionContainsPoint(PlotPoint[] container, PlotPoint plotCorner) {
        PlotPoint min = container[0];
        PlotPoint max = container[1];
        boolean withinXRange = min.getX() <= plotCorner.getX() && plotCorner.getX() <= max.getX();
        boolean withinZRange = min.getZ() <= plotCorner.getZ() && plotCorner.getZ() <= max.getZ();
        return withinXRange && withinZRange;
    }

    public static enum NameStatus {
        VALID(""),
        SPECIAL_CHARACTERS(Language.STATUS_SPECIAL_CHARACTERS.toString()),
        TOO_LONG(Language.STATUS_TOO_LONG.toString()),
        NAME_TAKEN(Language.STATUS_NAME_TAKEN.toString()),
        RESERVED_NAME(Language.STATUS_RESERVED_NAME.toString());

        private final String message;

        private NameStatus(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum RegionStatus {
        VALID(""),
        INVALID_WORLD(Language.STATUS_INVALID_WORLD.toString()),
        REGION_OCCUPIED(Language.STATUS_REGION_OCCUPIED.toString());

        private final String message;

        private RegionStatus(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

