/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.List;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.util.ProtectionUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ProtectionListener
implements Listener {
    private String PROTECTED_WARNING = ChatColor.RED + Language.WARN_PROTECTED.toString();
    private String PVP_WARNING = ChatColor.RED + Language.WARN_NO_PVP_ZONE.toString();

    public ProtectionListener() {
        Plugin plugin = PlayerPlot.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBuild(BlockPlaceEvent e) {
        Block block;
        Player builder = e.getPlayer();
        if (!this.isAllowed(builder, (block = e.getBlock()).getLocation())) {
            e.setCancelled(true);
            ProtectionListener.sendWarning(e.getPlayer(), this.PROTECTED_WARNING, block);
        }
    }

    private static void sendWarning(Player player, String message) {
        ProtectionListener.sendErrorEffect(player, player.getLocation());
        if (PluginConfig.isWarnMessage()) {
            player.sendMessage(message);
        }
    }

    private static void sendWarning(Player player, String message, Entity entity) {
        Location location = entity.getLocation().add(0.0, entity.getHeight() / 2.0, 0.0);
        ProtectionListener.sendErrorEffect(player, location);
        if (PluginConfig.isWarnMessage()) {
            player.sendMessage(message);
        }
    }

    private static void sendWarning(Player player, String message, Block block) {
        Location location = block.getLocation();
        location.add(0.5, 0.0, 0.5);
        Material material = block.getType();
        if (ProtectionUtil.isSmallBlock(material)) {
            location.add(0.0, 0.3, 0.0);
        } else if (ProtectionUtil.isMediumBlock(material)) {
            location.add(0.0, 0.8, 0.0);
        } else {
            location.add(0.0, 1.3, 0.0);
        }
        ProtectionListener.sendErrorEffect(player, location);
        if (PluginConfig.isWarnMessage()) {
            player.sendMessage(message);
        }
    }

    private static void sendErrorEffect(Player player, Location location) {
        if (PluginConfig.isWarnSound()) {
            player.playSound(location, Sound.ENTITY_BLAZE_HURT, 1.0f, 0.7f);
        }
        if (PluginConfig.isWarnParticle()) {
            location.getWorld().spawnParticle(Particle.SMOKE_NORMAL, location, 2, 0.0, 0.0, 0.0, 0.05);
        }
    }

    @Deprecated
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPiston(BlockPistonExtendEvent e) {
        Block piston = e.getBlock();
        Vector direction = e.getDirection().getDirection();
        Plot pistonPlot = PlotCache.getPlot(piston.getLocation());
        for (Block block : e.getBlocks()) {
            Plot blockPlot = PlotCache.getPlot(block.getLocation().add(direction.getX(), 0.0, direction.getZ()));
            if (blockPlot == null || blockPlot == pistonPlot) continue;
            e.setCancelled(true);
            return;
        }
    }

    @Deprecated
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        Block piston = e.getBlock();
        Vector direction = e.getDirection().getDirection();
        direction.multiply(-1);
        Plot pistonPlot = PlotCache.getPlot(piston.getLocation());
        for (Block block : e.getBlocks()) {
            Plot blockPlot = PlotCache.getPlot(block.getLocation().add(direction.getX(), 0.0, direction.getZ()));
            if (blockPlot == null || blockPlot == pistonPlot) continue;
            e.setCancelled(true);
            return;
        }
    }

    @Deprecated
    private Vector getDirection(Block piston) {
        byte data = piston.getData();
        if (data == 2) {
            return new Vector(0, 0, -1);
        }
        if (data == 3) {
            return new Vector(0, 0, 1);
        }
        if (data == 4) {
            return new Vector(-1, 0, 0);
        }
        if (data == 5) {
            return new Vector(1, 0, 0);
        }
        return new Vector();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFlow(BlockFromToEvent e) {
        Plot plotFrom;
        Plot plotTo = PlotCache.getPlot(e.getToBlock().getLocation());
        if (plotTo != null && plotTo != (plotFrom = PlotCache.getPlot(e.getBlock().getLocation()))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityChangeBlock(EntityChangeBlockEvent e) {
        if (e.getEntity().getType() == EntityType.ENDERMAN && PlotCache.hasPlot(e.getBlock().getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBreak(BlockBreakEvent e) {
        Block block;
        Player breaker = e.getPlayer();
        if (!this.isAllowed(breaker, (block = e.getBlock()).getLocation())) {
            e.setCancelled(true);
            ProtectionListener.sendWarning(breaker, this.PROTECTED_WARNING, block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteractAt(PlayerInteractAtEntityEvent e) {
        if (ProtectionUtil.isInteractableAtEntity(e.getRightClicked().getType())) {
            Entity entity = e.getRightClicked();
            if (!this.isAllowed(e.getPlayer(), entity.getLocation())) {
                e.setCancelled(true);
                ProtectionListener.sendWarning(e.getPlayer(), this.PROTECTED_WARNING, entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        if (ProtectionUtil.isInteractableEntity(e.getRightClicked().getType())) {
            Entity entity = e.getRightClicked();
            if (!this.isAllowed(e.getPlayer(), entity.getLocation())) {
                e.setCancelled(true);
                ProtectionListener.sendWarning(e.getPlayer(), this.PROTECTED_WARNING, entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent e) {
        Action action = e.getAction();
        Block block = e.getClickedBlock();
        Material blockMaterial = e.hasBlock() ? block.getType() : Material.AIR;
        Player player = e.getPlayer();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Material handMaterial;
            Material material = handMaterial = e.hasItem() ? e.getItem().getType() : Material.AIR;
            if (ProtectionUtil.isProtectedInteraction(handMaterial, blockMaterial) && !this.isAllowed(player, block.getLocation())) {
                e.setCancelled(true);
                ProtectionListener.sendWarning(player, this.PROTECTED_WARNING, block);
            }
        } else if (action == Action.PHYSICAL && blockMaterial == Material.FARMLAND && !this.isAllowed(e.getPlayer(), block.getLocation())) {
            e.setCancelled(true);
            ProtectionListener.sendWarning(player, this.PROTECTED_WARNING, block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDestroy(HangingBreakByEntityEvent e) {
        Hanging entity;
        Player player;
        if (e.getRemover() instanceof Player && !this.isAllowed(player = (Player)e.getRemover(), (entity = e.getEntity()).getLocation())) {
            e.setCancelled(true);
            ProtectionListener.sendWarning(player, this.PROTECTED_WARNING, (Entity)entity);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockExplode(BlockExplodeEvent e) {
        List blockList = e.blockList();
        for (int i = blockList.size() - 1; i >= 0; --i) {
            if (!PlotCache.hasPlot(((Block)blockList.get(i)).getLocation())) continue;
            blockList.remove(i);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent e) {
        List blockList = e.blockList();
        for (int i = blockList.size() - 1; i >= 0; --i) {
            if (!PlotCache.hasPlot(((Block)blockList.get(i)).getLocation())) continue;
            blockList.remove(i);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFire(BlockIgniteEvent e) {
        if (e.getCause() == BlockIgniteEvent.IgniteCause.SPREAD && PlotCache.hasPlot(e.getIgnitingBlock().getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFire(BlockBurnEvent e) {
        if (PlotCache.hasPlot(e.getBlock().getLocation())) {
            e.getBlock().setType(Material.AIR);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent e) {
        Block block;
        if (!(e.getEntity() instanceof Villager) && (block = e.getBlock()).getType() == Material.FARMLAND && PlotCache.hasPlot(block.getLocation())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHurt(EntityDamageByEntityEvent e) {
        Entity victim = e.getEntity();
        Player damager = this.getPlayer(e.getDamager());
        if (damager != null) {
            if (victim instanceof Player) {
                if (!PluginConfig.isPlotPvp()) {
                    if (PlotCache.hasPlot(victim.getLocation())) {
                        e.setCancelled(true);
                        ProtectionListener.sendWarning(damager, this.PVP_WARNING, victim);
                    } else if (PlotCache.hasPlot(damager.getLocation())) {
                        e.setCancelled(true);
                        ProtectionListener.sendWarning(damager, this.PVP_WARNING);
                    }
                }
            } else if (!(ProtectionUtil.isMonster(victim) || ProtectionUtil.isFighting(victim) || this.isAllowed(damager, victim.getLocation()))) {
                e.setCancelled(true);
                ProtectionListener.sendWarning(damager, this.PROTECTED_WARNING, victim);
            }
        }
    }

    private boolean isAllowed(Player player, Location location) {
        Plot plot = PlotCache.getPlot(location);
        return plot != null ? plot.isAllowed(player) : true;
    }

    private Player getPlayer(Entity entity) {
        if (entity instanceof Player) {
            return (Player)entity;
        }
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (projectile.getShooter() instanceof Player) {
                return (Player)projectile.getShooter();
            }
            return null;
        }
        return null;
    }
}

