/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.util.Scheduler;
import me.sword7.playerplot.util.border.Border;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlotScanner
implements Listener {
    private static Map<UUID, UUID> playerToScanner = new HashMap<UUID, UUID>();

    public PlotScanner() {
        Plugin plugin = PlayerPlot.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onPunch(PlayerInteractEvent e) {
        Player player;
        UUID playerId;
        Action action = e.getAction();
        if ((action == Action.LEFT_CLICK_BLOCK || action == Action.LEFT_CLICK_AIR) && Border.hasBorder(playerId = (player = e.getPlayer()).getUniqueId()) && playerToScanner.containsKey(playerId)) {
            UUID bId = playerToScanner.get(playerId);
            Border.hide(player, bId);
        }
    }

    public static void showPlot(Player player, Plot plot, int durationSec) {
        if (plot.contains(player.getLocation())) {
            UUID playerID = player.getUniqueId();
            UUID bId = Border.showPlot(player, plot);
            playerToScanner.put(playerID, bId);
            Scheduler.runLater(() -> Border.hide(player, bId), 20 * durationSec);
        }
    }
}

