/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.sword7.playerplot.config.PluginBase;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotDatabase;
import me.sword7.playerplot.plot.PlotFlatFile;
import me.sword7.playerplot.util.Friend;
import me.sword7.playerplot.util.GridZone;
import me.sword7.playerplot.util.MapUtil;
import me.sword7.playerplot.util.PlotPoint;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlotCache {
    private static PlotFlatFile plotFlatFile = new PlotFlatFile();
    private static HashMap<UUID, Plot> IDToPlot = new HashMap();
    private static HashMap<GridZone, List<Plot>> zoneToPlots = new HashMap();
    private static HashMap<UUID, List<Plot>> playerToPlots = new HashMap();
    private static HashMap<UUID, List<Plot>> playerToFPlots = new HashMap();
    private static Set<UUID> unsavedPlots = new HashSet<UUID>();
    private static boolean usingDatabase = PluginConfig.isUsingDatabase();
    private static PlotDatabase database = usingDatabase ? new PlotDatabase() : null;

    public PlotCache() {
        this.load();
    }

    private void load() {
        List<Plot> plots = usingDatabase ? database.fetchPlots() : plotFlatFile.fetch();
        for (Plot plot : plots) {
            IDToPlot.put(plot.getID(), plot);
            PlotCache.assignToZones(plot);
            MapUtil.addItemToList(playerToPlots, plot.getOwnerID(), plot);
            for (Friend friend : plot.getFriends()) {
                MapUtil.addItemToList(playerToFPlots, friend.getUuid(), plot);
            }
        }
        if (PluginBase.isDynmapDetected()) {
            PluginBase.getDynmap().registerPlots(plots);
        }
    }

    public static void assignToZones(Plot plot) {
        HashSet<GridZone> zones = new HashSet<GridZone>();
        for (PlotPoint corner : plot.getCorners()) {
            zones.add(GridZone.fromPlotPoint(corner));
        }
        for (GridZone gridZone : zones) {
            MapUtil.addItemToList(zoneToPlots, gridZone, plot);
        }
    }

    public static void shutdown() {
        PlotCache.save();
        IDToPlot.clear();
        zoneToPlots.clear();
        playerToPlots.clear();
        playerToFPlots.clear();
    }

    public static void save() {
        if (usingDatabase) {
            for (UUID plotID : unsavedPlots) {
                database.storePlot(plotID, IDToPlot.get(plotID));
            }
        } else {
            for (UUID plotID : unsavedPlots) {
                PlotFlatFile.store(plotID, IDToPlot.get(plotID));
            }
            plotFlatFile.save();
        }
        unsavedPlots.clear();
    }

    public static Plot getPlot(Location location) {
        GridZone zone = GridZone.fromLocation(location);
        if (zoneToPlots.containsKey(zone)) {
            for (Plot plot : zoneToPlots.get(zone)) {
                if (!plot.contains(location)) continue;
                return plot;
            }
        }
        return null;
    }

    public static boolean hasPlot(Location location) {
        GridZone zone = GridZone.fromLocation(location);
        if (zoneToPlots.containsKey(zone)) {
            for (Plot plot : zoneToPlots.get(zone)) {
                if (!plot.contains(location)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection<Plot> getAllPlots() {
        return IDToPlot.values();
    }

    public static Set<Plot> getPlotsNear(Location location, int sideLength) {
        HashSet<Plot> closePlots = new HashSet<Plot>();
        for (PlotPoint plotCorner : PlotPoint.fromLocation(location).getCorners(sideLength)) {
            GridZone zone = GridZone.fromPlotPoint(plotCorner);
            if (!zoneToPlots.containsKey(zone)) continue;
            for (Plot plot : zoneToPlots.get(zone)) {
                if (!location.getWorld().getName().equals(plot.getWorld())) continue;
                closePlots.add(plot);
            }
        }
        return closePlots;
    }

    public static void registerPlot(Plot plot) {
        IDToPlot.put(plot.getID(), plot);
        MapUtil.addItemToList(playerToPlots, plot.getOwnerID(), plot);
        unsavedPlots.add(plot.getID());
        PlotCache.assignToZones(plot);
    }

    public static void removePlot(Plot plot) {
        IDToPlot.remove(plot.getID());
        MapUtil.removeItemFromList(playerToPlots, plot.getOwnerID(), plot);
        unsavedPlots.add(plot.getID());
        for (Friend friend : plot.getFriends()) {
            PlotCache.registerFriendRemove(friend, plot);
        }
        PlotCache.unassignFromZones(plot);
    }

    public static void unassignFromZones(Plot plot) {
        HashSet<GridZone> zones = new HashSet<GridZone>();
        for (PlotPoint corner : plot.getCorners()) {
            zones.add(GridZone.fromPlotPoint(corner));
        }
        for (GridZone gridZone : zones) {
            MapUtil.removeItemFromList(zoneToPlots, gridZone, plot);
        }
    }

    public static void touch(Plot plot) {
        unsavedPlots.add(plot.getID());
    }

    public static List<Plot> getFriendPlots(Player player) {
        ArrayList<Plot> toReturn = new ArrayList<Plot>();
        List<Plot> fPlots = playerToFPlots.get(player.getUniqueId());
        if (fPlots != null) {
            toReturn.addAll(fPlots);
        }
        return toReturn;
    }

    public static void registerFriendAdd(Friend friend, Plot plot) {
        MapUtil.addItemToList(playerToFPlots, friend.getUuid(), plot);
    }

    public static void registerFriendRemove(Friend friend, Plot plot) {
        MapUtil.removeItemFromList(playerToFPlots, friend.getUuid(), plot);
    }

    public static List<Plot> getPlayerPlots(UUID playerID) {
        List<Plot> plots;
        ArrayList<Plot> toReturn = new ArrayList<Plot>();
        if (playerToPlots.containsKey(playerID) && (plots = playerToPlots.get(playerID)) != null) {
            toReturn.addAll(plots);
        }
        return toReturn;
    }

    public static Plot getPlayerPlot(UUID playerID, String plotName) {
        for (Plot plot : PlotCache.getPlayerPlots(playerID)) {
            if (!plot.getName().equalsIgnoreCase(plotName)) continue;
            return plot;
        }
        return null;
    }

    public static int getPlayerPlotsUsed(UUID playerID) {
        int plotsUsed = 0;
        for (Plot plot : PlotCache.getPlayerPlots(playerID)) {
            plotsUsed += plot.getComponents();
        }
        return plotsUsed;
    }
}

