/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.sword7.playerplot.PlayerPlot;
import me.sword7.playerplot.util.Scheduler;
import me.sword7.playerplot.util.border.Border;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlotBeam
extends BukkitRunnable {
    private static Map<UUID, PlotBeam> playerToBeam = new HashMap<UUID, PlotBeam>();
    private static final Vector UP_VELOCITY = new Vector(0.0, 0.05, 0.0);
    private static final Vector DOWN_VELOCITY = new Vector(0.0, -0.05, 0.0);
    private Player player;
    private UUID playerId;
    private Location destination;
    private int frame;

    public static boolean isBeaming(UUID playerId) {
        return playerToBeam.containsKey(playerId);
    }

    public static PlotBeam getBeam(UUID playerId) {
        return playerToBeam.get(playerId);
    }

    public static void shutdown() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID playerId = player.getUniqueId();
            if (!playerToBeam.containsKey(playerId)) continue;
            playerToBeam.get(playerId).end();
        }
    }

    public PlotBeam(Player player, Location destination) {
        this.player = player;
        if (player.getVehicle() != null) {
            player.getVehicle().eject();
        }
        this.playerId = player.getUniqueId();
        this.destination = destination;
        this.frame = 0;
        this.runTaskTimer(PlayerPlot.getPlugin(), 0L, 1L);
        playerToBeam.put(this.playerId, this);
    }

    public void run() {
        if (this.frame == 0) {
            PlotBeam.showBeam(this.player, 20);
            PlotBeam.playSound(this.player);
            this.player.setVelocity(UP_VELOCITY);
        } else if (this.frame < 20) {
            this.player.setVelocity(UP_VELOCITY.clone().multiply(this.frame));
        } else if (this.frame == 20) {
            this.player.teleport(this.getHighestUnObstructed(this.destination, 6));
            PlotBeam.showBeam(this.player, 20);
            PlotBeam.playSound(this.player);
            this.player.setVelocity(DOWN_VELOCITY);
            this.player.setFallDistance(0.0f);
        } else if (this.frame < 40) {
            this.player.setVelocity(DOWN_VELOCITY.clone().multiply(40 - this.frame));
            this.player.setFallDistance(0.0f);
        } else {
            this.endNaturally();
        }
        ++this.frame;
    }

    public void endNaturally() {
        playerToBeam.remove(this.playerId);
        this.cancel();
    }

    public void end() {
        this.player.teleport(this.destination);
        playerToBeam.remove(this.playerId);
        this.cancel();
    }

    private static void playSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 1.9f);
    }

    private static void showBeam(Player player, int durationTicks) {
        UUID bId = Border.showBeam(player);
        Scheduler.runLater(() -> Border.hide(player, bId), durationTicks);
    }

    private Location getHighestUnObstructed(Location destination, int maxHeight) {
        Vector toAdd = new Vector(0, 1, 0);
        Location loc = destination.clone();
        Block block = loc.getBlock();
        for (int height = 0; !block.getType().isSolid() && height <= maxHeight; ++height) {
            loc.add(toAdd);
            block = loc.getBlock();
        }
        return loc;
    }
}

