/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.util.Friend;
import me.sword7.playerplot.util.LocationParts;
import me.sword7.playerplot.util.PlotPoint;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Plot {
    private final UUID ID;
    private final UUID ownerID;
    private String ownerName;
    private String name;
    private String world;
    private List<Friend> friends = new ArrayList<Friend>();
    private Set<UUID> trustedIDs = new HashSet<UUID>();
    private PlotPoint minCorner;
    private PlotPoint maxCorner;
    private int components = 1;
    private LocationParts spawnParts;
    private int sideLength;
    private PlotPoint center;
    private PlotPoint[] corners;

    public Plot(Player player, Location location, String name, int sideLength) {
        this.ID = UUID.randomUUID();
        this.ownerID = player.getUniqueId();
        this.ownerName = player.getName();
        this.name = name;
        this.world = location.getWorld().getName();
        this.minCorner = PlotPoint.fromLocation(location).getMinCorner(sideLength);
        this.maxCorner = PlotPoint.fromLocation(location).getMaxCorner(sideLength);
        this.initialize();
    }

    public Plot(UUID plotID, String name, UUID ownerID, String ownerName, PlotPoint minCorner, PlotPoint maxCorner, String world, int components, List<Friend> friends, LocationParts spawnParts) {
        this.ID = plotID;
        this.name = name;
        this.ownerID = ownerID;
        this.ownerName = ownerName;
        this.minCorner = minCorner;
        this.maxCorner = maxCorner;
        this.components = components;
        this.world = world;
        this.friends = friends;
        this.spawnParts = spawnParts;
        this.initialize();
    }

    public void setRegion(PlotPoint minCorner, PlotPoint maxCorner) {
        this.minCorner = minCorner;
        this.maxCorner = maxCorner;
        this.initialize();
    }

    private void initialize() {
        for (Friend friend : this.friends) {
            this.trustedIDs.add(friend.getUuid());
        }
        this.trustedIDs.add(this.ownerID);
        this.sideLength = this.calculateSideLength();
        this.center = this.calculatePlotCenter();
        this.corners = this.calculateCorners();
    }

    public void setCenter(Location location) {
        this.world = location.getWorld().getName();
        this.minCorner = PlotPoint.fromLocation(location).getMinCorner(this.sideLength);
        this.maxCorner = PlotPoint.fromLocation(location).getMaxCorner(this.sideLength);
        this.center = this.calculatePlotCenter();
        this.corners = this.calculateCorners();
    }

    private int calculateSideLength() {
        return this.maxCorner.getX() - this.minCorner.getX() + 1;
    }

    private PlotPoint calculatePlotCenter() {
        boolean evenLength = this.sideLength % 2 == 0;
        int offSet = evenLength ? 0 : -1;
        int x = this.maxCorner.getX() - (this.sideLength + offSet) / 2;
        int z = this.maxCorner.getZ() - (this.sideLength + offSet) / 2;
        return new PlotPoint(x, z);
    }

    private PlotPoint[] calculateCorners() {
        PlotPoint[] corners = new PlotPoint[]{this.minCorner, this.maxCorner, new PlotPoint(this.minCorner.getX(), this.maxCorner.getZ()), new PlotPoint(this.maxCorner.getX(), this.minCorner.getZ())};
        return corners;
    }

    public void setSpawn(Location spawn) {
        this.spawnParts = new LocationParts(spawn);
    }

    public void removeSpawn() {
        this.spawnParts = null;
    }

    public LocationParts getSpawnParts() {
        return this.spawnParts;
    }

    public Location getSpawn() {
        if (this.spawnParts != null) {
            return this.spawnParts.getLocation();
        }
        World world = Bukkit.getWorld((String)this.world);
        if (world != null) {
            return world.getHighestBlockAt(this.center.asLocation(world)).getLocation().add(0.5, 1.0, 0.5);
        }
        return null;
    }

    public UUID getID() {
        return this.ID;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorld() {
        return this.world;
    }

    public int getComponents() {
        return this.components;
    }

    public void incrementComponents() {
        ++this.components;
    }

    public void decrementComponents() {
        --this.components;
    }

    public boolean contains(Location location) {
        return location != null && location.getWorld().getName().equals(this.world) && this.withinXRange(location) && this.withinZRange(location);
    }

    private boolean withinXRange(Location location) {
        int blockX = location.getBlockX();
        return this.minCorner.getX() <= blockX && blockX <= this.maxCorner.getX();
    }

    private boolean withinZRange(Location location) {
        int blockZ = location.getBlockZ();
        return this.minCorner.getZ() <= blockZ && blockZ <= this.maxCorner.getZ();
    }

    public PlotPoint getMinCorner() {
        return this.minCorner;
    }

    public PlotPoint getMaxCorner() {
        return this.maxCorner;
    }

    public PlotPoint[] getCorners() {
        return this.corners;
    }

    public int getSideLength() {
        return this.sideLength;
    }

    public PlotPoint getCenter() {
        return this.center;
    }

    public boolean isAllowed(Player player) {
        return Permissions.canBuildEverywhere((CommandSender)player) || this.trustedIDs.contains(player.getUniqueId());
    }

    public boolean isFriend(String friendName) {
        for (Friend friend : this.friends) {
            if (!friend.getName().equalsIgnoreCase(friendName)) continue;
            return true;
        }
        return false;
    }

    public Friend getFriend(String friendName) {
        for (Friend friend : this.friends) {
            if (!friend.getName().equalsIgnoreCase(friendName)) continue;
            return friend;
        }
        return null;
    }

    public void addFriend(Friend friend) {
        this.friends.add(friend);
        this.trustedIDs.add(friend.getUuid());
    }

    public void removeFriend(String friendName) {
        for (int i = this.friends.size() - 1; i >= 0; --i) {
            Friend friend = this.friends.get(i);
            if (!friend.getName().equalsIgnoreCase(friendName)) continue;
            this.friends.remove(friend);
            this.trustedIDs.remove(friend.getUuid());
        }
    }

    public List<Friend> getFriends() {
        return this.friends;
    }

    public boolean equals(Object o) {
        if (o instanceof Plot) {
            return this.ID.equals(((Plot)o).ID);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 37).append((Object)this.ID).toHashCode();
    }
}

