/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.plot;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.config.PluginBase;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.integration.Dynmap;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.plot.PlotScanner;
import me.sword7.playerplot.plot.Validation;
import me.sword7.playerplot.user.UserCache;
import me.sword7.playerplot.user.UserData;
import me.sword7.playerplot.util.Friend;
import me.sword7.playerplot.util.Help;
import me.sword7.playerplot.util.InfoList;
import me.sword7.playerplot.util.PermInfo;
import me.sword7.playerplot.util.PlotPoint;
import me.sword7.playerplot.util.PlotUtil;
import me.sword7.playerplot.util.Scheduler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPlot
implements CommandExecutor {
    private boolean usingDynmap = PluginBase.isDynmapDetected();
    private Dynmap dynmap = PluginBase.getDynmap();
    private ImmutableSet<String> plotActionArgs = new ImmutableSet.Builder().add((Object)"info").add((Object)"free").add((Object)"trust").add((Object)"untrust").add((Object)"upgrade").add((Object)"downgrade").add((Object)"setcenter").add((Object)"setspawn").add((Object)"rename").build();

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        Player player;
        UUID playerID;
        if (sender instanceof Player && UserCache.hasData(playerID = (player = (Player)sender).getUniqueId())) {
            if (args.length == 0) {
                Help.sendPlots(player);
            } else {
                String sub = args[0].toLowerCase();
                if (sub.equals("scan")) {
                    this.processScan(player, args);
                } else if (sub.equals("claim")) {
                    this.processClaim(player, args);
                } else if (sub.equals("list")) {
                    this.processList(player, args);
                } else if (sub.equals("flist")) {
                    this.processFList(player, args);
                } else if (this.plotActionArgs.contains((Object)args[0]) || args[0].startsWith("@")) {
                    this.processPlotAction(player, args, (plot, effectiveArgs) -> {
                        if (effectiveArgs.length > 0) {
                            String effectiveSub;
                            switch (effectiveSub = effectiveArgs[0].toLowerCase()) {
                                case "info": {
                                    this.processInfo(player, plot);
                                    break;
                                }
                                case "free": {
                                    this.processFree(player, plot);
                                    break;
                                }
                                case "trust": {
                                    this.processTrust(player, plot, effectiveArgs);
                                    break;
                                }
                                case "untrust": {
                                    this.processUntrust(player, plot, effectiveArgs);
                                    break;
                                }
                                case "upgrade": {
                                    this.processUpgrade(player, plot);
                                    break;
                                }
                                case "downgrade": {
                                    this.processDowngrade(player, plot);
                                    break;
                                }
                                case "setcenter": {
                                    this.processSetCenter(player, plot);
                                    break;
                                }
                                case "setspawn": {
                                    this.processSetSpawn(player, plot);
                                    break;
                                }
                                case "rename": {
                                    this.processRename(player, plot, effectiveArgs);
                                    break;
                                }
                                default: {
                                    Help.sendPlots(player);
                                    break;
                                }
                            }
                        } else {
                            Help.sendPlots(player);
                        }
                    });
                } else {
                    Help.sendPlots(player);
                }
            }
        }
        return false;
    }

    private void processPlotAction(Player player, String[] args, IPlotAction action) {
        if (args[0].startsWith("@")) {
            String[] effectiveArgs = Arrays.copyOfRange(args, 1, args.length);
            if (!args[0].equals("@here")) {
                String targetName = args[0].substring(1);
                Plot targetPlot = PlotCache.getPlayerPlot(player.getUniqueId(), targetName);
                if (targetPlot != null) {
                    action.run(targetPlot, effectiveArgs);
                } else {
                    player.sendMessage(Language.WARN_PLOT_NOT_FOUND.coloredFromPlot(targetName, ChatColor.RED, ChatColor.DARK_RED));
                }
            } else {
                this.processStandingAction(player, effectiveArgs, action);
            }
        } else {
            this.processStandingAction(player, args, action);
        }
    }

    private void processStandingAction(Player player, String[] args, IPlotAction action) {
        Plot targetPlot = PlotCache.getPlot(player.getLocation());
        if (targetPlot != null) {
            if (targetPlot.getOwnerID().equals(player.getUniqueId())) {
                action.run(targetPlot, args);
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_NOT_OWNER.toString());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_STANDING_IN_PLOT.toString());
        }
    }

    private void processScan(Player player, String[] args) {
        if (Permissions.canPlotScan((CommandSender)player)) {
            int duration = args.length > 1 && (args[1].equalsIgnoreCase("-long") || args[1].equalsIgnoreCase("-l")) ? 30 : 6;
            Plot plot = PlotCache.getPlot(player.getLocation());
            if (plot != null) {
                player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 0.77f);
                player.sendMessage(Language.SCANNER_PLOT_OVERVIEW.fromPlayerAndPlot(plot.getOwnerName(), plot.getName()));
                PlotScanner.showPlot(player, plot, duration);
            } else {
                player.sendMessage(ChatColor.RED + Language.SCANNER_NO_PLOTS.toString());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processInfo(Player player, Plot plot) {
        if (Permissions.canPlotInfo((CommandSender)player)) {
            player.sendMessage(ChatColor.DARK_PURPLE + "- - - " + plot.getName() + " - - -");
            PlotPoint minCorner = plot.getMinCorner();
            PlotPoint maxCorner = plot.getMaxCorner();
            int length = maxCorner.getX() - minCorner.getX() + 1;
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_AREA.toString() + ": " + ChatColor.RESET + length + " x " + length);
            PlotPoint center = plot.getCenter();
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_CENTER.toString() + ": " + ChatColor.RESET + "x:" + center.getX() + " z:" + center.getZ());
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_MIN_CORNER.toString() + ": " + ChatColor.RESET + "x:" + minCorner.getX() + " z:" + minCorner.getZ());
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_MAX_CORNER.toString() + ": " + ChatColor.RESET + "x:" + maxCorner.getX() + " z:" + maxCorner.getZ());
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_WORLD.toString() + ": " + ChatColor.RESET + plot.getWorld());
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_COMPONENTS.toString() + ": " + ChatColor.RESET + plot.getComponents());
            player.sendMessage(ChatColor.LIGHT_PURPLE + Language.LABEL_FRIENDS.toString() + ":");
            player.sendMessage(PlotUtil.getFriendsAsString(plot));
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processClaim(Player player, String[] args) {
        if (Permissions.canPlotClaim((CommandSender)player)) {
            UUID playerID = player.getUniqueId();
            UserData userData = UserCache.getData(playerID);
            PermInfo permInfo = UserCache.getPerms(playerID);
            if (PlotCache.getPlayerPlotsUsed(playerID) < PluginConfig.getStartingPlotNum() + userData.getUnlockedPlots() + permInfo.getPlotBonus()) {
                int unitSideLength = PluginConfig.getPlotUnitSideLength();
                Validation.RegionStatus regionStatus = Validation.canPlotBeRegisteredAt(player.getLocation(), unitSideLength, null);
                if (regionStatus == Validation.RegionStatus.VALID) {
                    String plotName = args.length > 1 ? args[1] : PlotUtil.getDefaultName(playerID);
                    Validation.NameStatus nameStatus = Validation.cleanName(plotName, playerID);
                    if (nameStatus == Validation.NameStatus.VALID) {
                        Plot plot = new Plot(player, player.getLocation(), plotName, unitSideLength);
                        PlotCache.registerPlot(plot);
                        player.sendMessage(Language.SUCCESS_PLOT_CLAIM.coloredFromPlot(plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                        PlotScanner.showPlot(player, plot, 7);
                        if (this.usingDynmap) {
                            this.dynmap.registerPlot(plot);
                        }
                        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                    } else {
                        player.sendMessage(ChatColor.RED + nameStatus.getMessage());
                    }
                } else {
                    player.sendMessage(ChatColor.RED + regionStatus.getMessage());
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_PLOT_LIMIT.toString());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processFree(Player player, Plot plot) {
        if (Permissions.canPlotFree((CommandSender)player)) {
            PlotScanner.showPlot(player, plot, 1);
            PlotCache.removePlot(plot);
            if (this.usingDynmap) {
                this.dynmap.deletePlot(plot);
            }
            player.sendMessage(Language.SUCCESS_PLOT_FREE.coloredFromPlot(plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    public void processList(Player player, String[] args) {
        if (Permissions.canPlotList((CommandSender)player)) {
            ArrayList<String> items = new ArrayList<String>();
            for (Plot plot : PlotCache.getPlayerPlots(player.getUniqueId())) {
                items.add(PlotUtil.getListString(plot));
            }
            UUID playerID = player.getUniqueId();
            UserData userData = UserCache.getData(playerID);
            PermInfo permInfo = UserCache.getPerms(playerID);
            int used = PlotCache.getPlayerPlotsUsed(playerID);
            int capacity = PluginConfig.getStartingPlotNum() + userData.getUnlockedPlots() + permInfo.getPlotBonus();
            String title = ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD + Language.LABEL_PLOTS.toString() + " (" + ChatColor.AQUA + ChatColor.BOLD + used + ChatColor.LIGHT_PURPLE + ChatColor.BOLD + "/" + capacity + "): ";
            InfoList infoList = new InfoList(title, items, 7);
            int page = args.length > 1 ? PlotUtil.parseAmount(args[1]) : 1;
            infoList.displayTo((CommandSender)player, page);
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    public void processFList(Player player, String[] args) {
        if (Permissions.canPlotFList((CommandSender)player)) {
            ArrayList<String> items = new ArrayList<String>();
            for (Plot plot : PlotCache.getFriendPlots(player)) {
                items.add(PlotUtil.getFListString(plot));
            }
            String title = ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD + Language.LABEL_FRIEND_PLOTS.toString() + ": ";
            InfoList infoList = new InfoList(title, items, 7);
            int page = args.length > 1 ? PlotUtil.parseAmount(args[1]) : 1;
            infoList.displayTo((CommandSender)player, page);
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processTrust(Player player, Plot plot, String[] args) {
        if (Permissions.canPlotTrust((CommandSender)player)) {
            if (args.length > 1) {
                String targetName = args[1];
                Player target = Bukkit.getPlayer((String)targetName);
                if (target != null) {
                    Friend friend = new Friend(target);
                    if (!plot.getFriends().contains(friend)) {
                        if (!plot.getOwnerID().equals(friend.getUuid())) {
                            plot.addFriend(friend);
                            PlotCache.registerFriendAdd(friend, plot);
                            PlotCache.touch(plot);
                            player.sendMessage(Language.SUCCESS_PLOT_TRUST.coloredFromPlayerAndPlot(target.getName(), plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                            target.sendMessage(Language.SUCCESS_INVITED.coloredFromPlayerAndPlot(player.getName(), plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                        } else {
                            player.sendMessage(ChatColor.RED + Language.WARN_ADD_SELF.toString());
                        }
                    } else {
                        player.sendMessage(Language.WARN_ALREADY_FRIEND.coloredFromPlayerAndPlot(target.getName(), plot.getName(), ChatColor.RED, ChatColor.DARK_RED));
                    }
                } else {
                    player.sendMessage(Language.WARN_PLAYER_OFFLINE.coloredFromPlayer(targetName, ChatColor.RED, ChatColor.DARK_RED));
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.MISC_FORMAT.fromFormat("/" + PluginConfig.getRootCommand() + " trust [" + Language.ARG_PLAYER + "]"));
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processUntrust(Player player, Plot plot, String[] args) {
        if (Permissions.canPlotUntrust((CommandSender)player)) {
            if (args.length > 1) {
                String friendName = args[1];
                if (plot.isFriend(friendName)) {
                    Friend friend = plot.getFriend(friendName);
                    plot.removeFriend(friendName);
                    PlotCache.touch(plot);
                    PlotCache.registerFriendRemove(friend, plot);
                    player.sendMessage(Language.SUCCESS_PLOT_UNTRUST.coloredFromPlayerAndPlot(friendName, plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                } else {
                    player.sendMessage(Language.WARN_NOT_FRIEND.coloredFromPlayerAndPlot(friendName, plot.getName(), ChatColor.RED, ChatColor.DARK_RED));
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.MISC_FORMAT.fromFormat("/" + PluginConfig.getRootCommand() + " untrust [" + Language.ARG_PLAYER + "]"));
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processUpgrade(Player player, Plot plot) {
        if (Permissions.canPlotUpgrade((CommandSender)player)) {
            UUID playerID = player.getUniqueId();
            UserData userData = UserCache.getData(playerID);
            PermInfo permInfo = UserCache.getPerms(playerID);
            if (PlotCache.getPlayerPlotsUsed(playerID) < PluginConfig.getStartingPlotNum() + userData.getUnlockedPlots() + permInfo.getPlotBonus()) {
                int newSideLength = PlotUtil.getUpgradeLength(plot.getComponents());
                PlotPoint center = plot.getCenter();
                Validation.RegionStatus regionStatus = Validation.canPlotBeUpgradedAt(plot.getWorld(), center, newSideLength, plot.getID());
                if (regionStatus == Validation.RegionStatus.VALID) {
                    PlotScanner.showPlot(player, plot, 1);
                    player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                    PlotPoint newMin = center.getMinCorner(newSideLength);
                    PlotPoint newMax = center.getMaxCorner(newSideLength);
                    plot.setRegion(newMin, newMax);
                    plot.incrementComponents();
                    PlotCache.touch(plot);
                    if (this.usingDynmap) {
                        this.dynmap.updateMarker(plot);
                    }
                    Scheduler.runLater(() -> {
                        PlotScanner.showPlot(player, plot, 7);
                        player.sendMessage(Language.SUCCESS_PLOT_UPGRADE.coloredFromPlot(plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                    }, 23);
                } else {
                    player.sendMessage(ChatColor.RED + regionStatus.getMessage());
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_PLOT_LIMIT.toString());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processDowngrade(Player player, Plot plot) {
        if (Permissions.canPlotDowngrade((CommandSender)player)) {
            PlotPoint center = plot.getCenter();
            int newSideLength = PlotUtil.getDowngradeLength(plot.getComponents());
            if (newSideLength >= PluginConfig.getPlotUnitSideLength()) {
                PlotScanner.showPlot(player, plot, 1);
                player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
                PlotPoint newMin = center.getMinCorner(newSideLength);
                PlotPoint newMax = center.getMaxCorner(newSideLength);
                plot.setRegion(newMin, newMax);
                plot.decrementComponents();
                if (!plot.contains(plot.getSpawn())) {
                    plot.removeSpawn();
                }
                PlotCache.touch(plot);
                if (this.usingDynmap) {
                    this.dynmap.updateMarker(plot);
                }
                Scheduler.runLater(() -> {
                    PlotScanner.showPlot(player, plot, 7);
                    player.sendMessage(Language.SUCCESS_PLOT_DOWNGRADE.coloredFromPlot(plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                }, 23);
            } else {
                player.sendMessage(Language.WARN_NOT_DOWNGRADEABLE.coloredFromPlot(plot.getName(), ChatColor.RED, ChatColor.DARK_RED));
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processSetCenter(Player player, Plot plot) {
        if (Permissions.canPlotSetCenter((CommandSender)player)) {
            Location location = player.getLocation();
            Validation.RegionStatus regionStatus = Validation.canPlotBeRegisteredAt(location, plot.getSideLength(), plot.getID());
            if (regionStatus == Validation.RegionStatus.VALID) {
                PlotCache.unassignFromZones(plot);
                plot.setCenter(location);
                PlotCache.assignToZones(plot);
                if (!plot.contains(plot.getSpawn())) {
                    plot.removeSpawn();
                }
                PlotCache.touch(plot);
                player.sendMessage(Language.SUCCESS_PLOT_CENTER.coloredFromPlot(plot.getName(), ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                PlotScanner.showPlot(player, plot, 7);
                if (this.usingDynmap) {
                    this.dynmap.updatePlot(plot);
                }
                player.playSound(location, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
            } else {
                player.sendMessage(ChatColor.RED + regionStatus.getMessage());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processSetSpawn(Player player, Plot plot) {
        if (Permissions.canPlotSetSpawn((CommandSender)player)) {
            if (Permissions.canTeleport((CommandSender)player)) {
                Location location = player.getLocation();
                if (plot.contains(location)) {
                    plot.setSpawn(location);
                    PlotCache.touch(plot);
                    player.sendMessage(ChatColor.LIGHT_PURPLE + Language.SUCCESS_SPAWN_SET.toString());
                } else {
                    player.sendMessage(ChatColor.RED + Language.WARN_OUTSIDE_PLOT_BOUNDS.toString());
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private void processRename(Player player, Plot plot, String[] args) {
        if (Permissions.canPlotRename((CommandSender)player)) {
            if (args.length > 1) {
                String newName = args[1];
                Validation.NameStatus nameStatus = Validation.cleanName(newName, player.getUniqueId());
                if (nameStatus == Validation.NameStatus.VALID) {
                    plot.setName(newName);
                    PlotCache.touch(plot);
                    if (this.usingDynmap) {
                        this.dynmap.updatePlot(plot);
                    }
                    player.sendMessage(Language.SUCCESS_PLOT_RENAME.coloredFromPlot(newName, ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE));
                } else {
                    player.sendMessage(ChatColor.RED + nameStatus.getMessage());
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.MISC_FORMAT.fromFormat("/" + PluginConfig.getRootCommand() + " rename [" + Language.ARG_NAME + "]"));
            }
        } else {
            player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
        }
    }

    private static interface IPlotAction {
        public void run(Plot var1, String[] var2);
    }
}

