/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.util.PlotPoint;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class Dynmap {
    private MarkerAPI markerAPI;
    private DynmapAPI dynmapAPI;
    private MarkerSet playerPlotSet;
    private static int primaryColorInt = 13472717;
    private static int highlightColorInt = 7798968;
    private Map<UUID, AreaMarker> plotToMarker = new HashMap<UUID, AreaMarker>();

    public Dynmap(Plugin plugin) {
        assert (plugin instanceof DynmapAPI);
        this.dynmapAPI = (DynmapAPI)plugin;
        this.markerAPI = this.dynmapAPI.getMarkerAPI();
        this.playerPlotSet = this.markerAPI.createMarkerSet("playerplot.markerset", "Plots", this.markerAPI.getMarkerIcons(), false);
        this.playerPlotSet.setHideByDefault(!PluginConfig.isShowPlotMarkersByDefault());
    }

    public void registerPlots(List<Plot> plotList) {
        for (Plot plot : plotList) {
            this.drawPlot(plot);
        }
    }

    public void registerPlot(Plot plot) {
        this.drawPlot(plot);
    }

    public void deletePlot(Plot plot) {
        UUID plotID = plot.getID();
        if (this.plotToMarker.containsKey(plotID)) {
            AreaMarker areaMarker = this.plotToMarker.get(plotID);
            areaMarker.deleteMarker();
            this.plotToMarker.remove(plotID);
        }
    }

    public void updatePlot(Plot plot) {
        this.deletePlot(plot);
        this.registerPlot(plot);
    }

    public void updateMarker(Plot plot) {
        UUID plotID = plot.getID();
        if (this.plotToMarker.containsKey(plotID)) {
            PlotPoint min = plot.getMinCorner();
            PlotPoint max = plot.getMaxCorner();
            double[] x = new double[]{min.getX(), max.getX()};
            double[] z = new double[]{min.getZ(), max.getZ()};
            AreaMarker areaMarker = this.plotToMarker.get(plotID);
            areaMarker.setCornerLocations(x, z);
        } else {
            this.drawPlot(plot);
        }
    }

    private void drawPlot(Plot plot) {
        UUID plotID = plot.getID();
        PlotPoint min = plot.getMinCorner();
        PlotPoint max = plot.getMaxCorner();
        double[] x = new double[]{min.getX(), max.getX()};
        double[] z = new double[]{min.getZ(), max.getZ()};
        AreaMarker areaMarker = this.playerPlotSet.createAreaMarker(plotID.toString(), plot.getName() + " ~ " + plot.getOwnerName() + " ~", true, plot.getWorld(), x, z, false);
        try {
            areaMarker.setFillStyle(0.5, primaryColorInt);
            areaMarker.setLineStyle(2, 0.77, highlightColorInt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.plotToMarker.put(plotID, areaMarker);
    }

    public void shutdown() {
        for (AreaMarker marker : this.plotToMarker.values()) {
            marker.deleteMarker();
        }
    }
}

