/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import me.sword7.playerplot.PlayerPlot;

public class ConfigLoader {
    private static final String pluginFolder = "PlayerPlot";
    private static ImmutableList<String> configs = new ImmutableList.Builder().add((Object)"config").build();
    private static ImmutableList<String> languages = new ImmutableList.Builder().add((Object)"cs").add((Object)"de").add((Object)"en").add((Object)"es").add((Object)"fr").add((Object)"it").add((Object)"ko").add((Object)"lt").add((Object)"pl").add((Object)"ru").build();

    public static void load() {
        try {
            File target;
            for (String config : configs) {
                target = new File("plugins/PlayerPlot", config + ".yml");
                if (target.exists()) continue;
                ConfigLoader.load("config/" + config + ".yml", target);
            }
            for (String lang : languages) {
                target = new File("plugins/PlayerPlot/locale", lang + ".yml");
                if (target.exists()) continue;
                ConfigLoader.load("locale/" + lang + ".yml", target);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void load(String resource, File file) throws IOException {
        file.getParentFile().mkdirs();
        InputStream in = PlayerPlot.getPlugin().getResource(resource);
        Files.copy(in, file.toPath(), new CopyOption[0]);
        in.close();
    }
}

