/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.admin;

import java.util.UUID;
import me.sword7.playerplot.admin.DeleteRequests;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.util.Scheduler;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandDelPlot
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (Permissions.canDeletePlots((CommandSender)player)) {
                Plot plot = PlotCache.getPlot(player.getLocation());
                if (plot != null) {
                    DeleteRequests.Request request = DeleteRequests.add(player, plot);
                    UUID requestId = request.getId();
                    player.spigot().sendMessage((BaseComponent)Language.INFO_CONFIRM_DELETE.getWithPlayerConfirmDeny(ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE, plot.getOwnerName(), "/delplotconfirm", "/delplotcancel"));
                    player.sendMessage(ChatColor.GRAY + Language.INFO_REQUEST_DURATION.fromSeconds(25));
                    Scheduler.runLater(() -> {
                        DeleteRequests.Request currentRequest;
                        if (DeleteRequests.hasPending(player) && (currentRequest = DeleteRequests.getPending(player)).getId().equals(requestId)) {
                            DeleteRequests.remove(player);
                        }
                    }, 500);
                } else {
                    player.sendMessage(ChatColor.RED + Language.WARN_NOT_STANDING_IN_PLOT.toString());
                }
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
            }
        }
        return false;
    }
}

