/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot.admin;

import java.util.ArrayList;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.Permissions;
import me.sword7.playerplot.plot.Plot;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.util.InfoList;
import me.sword7.playerplot.util.PlotPoint;
import me.sword7.playerplot.util.PlotUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandAllPlots
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (Permissions.canViewAllPlots((CommandSender)player)) {
                ArrayList<String> items = new ArrayList<String>();
                for (Plot plot : PlotCache.getAllPlots()) {
                    items.add(this.getListString(plot));
                }
                InfoList infoList = new InfoList(ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD + Language.LABEL_ALL_PLOTS.toString() + " (" + items.size() + "):", items, 7);
                int page = args.length > 0 ? PlotUtil.parseAmount(args[0]) : 1;
                infoList.displayTo((CommandSender)player, page);
            } else {
                player.sendMessage(ChatColor.RED + Language.WARN_NOT_PERMITTED.toString());
            }
        }
        return false;
    }

    private String getListString(Plot plot) {
        String name = plot.getName();
        String ownerName = plot.getOwnerName();
        PlotPoint center = plot.getCenter();
        String displayString = ChatColor.DARK_PURPLE + name + " - " + ChatColor.LIGHT_PURPLE + ownerName;
        displayString = displayString + " " + ChatColor.GRAY + "(" + plot.getWorld() + ", " + center.getX() + ", " + center.getZ() + ")";
        return displayString;
    }
}

