/*
 * Decompiled with CFR 0.152.
 */
package me.sword7.playerplot;

import me.sword7.playerplot.CommandPlayerPlot;
import me.sword7.playerplot.PlayerPlotAPI;
import me.sword7.playerplot.admin.CommandAllPlots;
import me.sword7.playerplot.admin.CommandDelPlot;
import me.sword7.playerplot.admin.CommandDelPlotCancel;
import me.sword7.playerplot.admin.CommandDelPlotConfirm;
import me.sword7.playerplot.config.ConfigLoader;
import me.sword7.playerplot.config.Language;
import me.sword7.playerplot.config.PluginBase;
import me.sword7.playerplot.config.PluginConfig;
import me.sword7.playerplot.plot.CommandPlot;
import me.sword7.playerplot.plot.CommandToPlot;
import me.sword7.playerplot.plot.PlotBeam;
import me.sword7.playerplot.plot.PlotCache;
import me.sword7.playerplot.plot.PlotListener;
import me.sword7.playerplot.plot.PlotScanner;
import me.sword7.playerplot.plot.ProtectionListener;
import me.sword7.playerplot.plotdeed.CommandLoot;
import me.sword7.playerplot.plotdeed.CommandWriteDeed;
import me.sword7.playerplot.plotdeed.PlotDeedListener;
import me.sword7.playerplot.plotdeed.PlotDeedLoot;
import me.sword7.playerplot.plotdeed.PlotDeedType;
import me.sword7.playerplot.user.UserCache;
import me.sword7.playerplot.util.AutoCompleteListener;
import me.sword7.playerplot.util.border.Border;
import me.sword7.playerplot.util.storage.DatabaseConnection;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerPlot
extends JavaPlugin {
    private static Plugin plugin;
    private PlayerPlotAPI playerPlotAPI = PlayerPlotAPI.getInstance();

    public void onEnable() {
        plugin = this;
        ConfigLoader.load();
        new PluginConfig();
        Language.load();
        PlotDeedType.init();
        new PluginBase();
        new PlotCache();
        new UserCache();
        this.getCommand("playerplot").setExecutor((CommandExecutor)new CommandPlayerPlot());
        this.getCommand(PluginConfig.getRootCommand()).setExecutor((CommandExecutor)new CommandPlot());
        this.getCommand("plotdeed").setExecutor((CommandExecutor)new CommandLoot(new PlotDeedLoot()));
        this.getCommand("toplot").setExecutor((CommandExecutor)new CommandToPlot());
        this.getCommand("writedeed").setExecutor((CommandExecutor)new CommandWriteDeed());
        this.getCommand("allplots").setExecutor((CommandExecutor)new CommandAllPlots());
        this.getCommand("delplot").setExecutor((CommandExecutor)new CommandDelPlot());
        this.getCommand("delplotconfirm").setExecutor((CommandExecutor)new CommandDelPlotConfirm());
        this.getCommand("delplotcancel").setExecutor((CommandExecutor)new CommandDelPlotCancel());
        new AutoCompleteListener();
        new ProtectionListener();
        new PlotListener();
        new PlotDeedListener();
        new PlotScanner();
    }

    public void onDisable() {
        if (PluginBase.isDynmapDetected()) {
            PluginBase.getDynmap().shutdown();
        }
        UserCache.shutdown();
        PlotCache.shutdown();
        if (PluginConfig.isUsingDatabase()) {
            DatabaseConnection.shutdown();
        }
        Border.shutdown();
        PlotBeam.shutdown();
    }

    public static void reload() {
        ConfigLoader.load();
        PluginConfig.reload();
        Language.reload();
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public PlayerPlotAPI getPlayerPlotAPI() {
        return this.playerPlotAPI;
    }
}

