/*
 * Decompiled with CFR 0.152.
 */
package com.rot4tion.set_items.templates;

import com.rot4tion.Swapper;
import com.rot4tion.set_items.DataManager.DataPersistent;
import com.rot4tion.set_items.DataManager.SetItemsManager;
import com.rot4tion.set_items.Enum.SetItemType;
import com.rot4tion.set_items.Handler.SetItemsEventHandler;
import com.rot4tion.set_items.Manager;
import com.rot4tion.set_items.templates.DataSetItems;
import com.rot4tion.template.myConfig;
import com.rot4tion.util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SetItems {
    private String title;
    private Inventory inventory;

    public SetItems(String title, Inventory inventory) {
        if (inventory == null) {
            this.inventory = Bukkit.createInventory(null, (int)9, (String)title);
        }
        this.title = title;
        this.inventory = inventory;
    }

    public boolean UseItem(Player p, SetItemType setItemType) {
        Swapper.Debug("UseItem");
        PlayerInventory pi = p.getInventory();
        int index = setItemType.ordinal();
        ItemStack itemUse = this.getItem(index);
        if (!Manager.CheckIsCustomNullItem(itemUse)) {
            ItemStack itemNeedMove = util.getItemEquipOnPlayer(p, setItemType);
            if (!util.isNullItem(itemNeedMove)) {
                boolean isMovedItemNeedMove = false;
                if (itemNeedMove.hasItemMeta() && itemNeedMove.getItemMeta().getPersistentDataContainer().has(DataPersistent.setItemLast, PersistentDataType.STRING)) {
                    ItemStack itemStack;
                    SetItems lastSetItems;
                    String titleSetItemLast = (String)itemNeedMove.getItemMeta().getPersistentDataContainer().get(DataPersistent.setItemLast, PersistentDataType.STRING);
                    DataSetItems dataSetItems = SetItemsManager.getDataSetItemsByPlayer(p);
                    if (dataSetItems != null && (lastSetItems = dataSetItems.getSetItemsByTitle(titleSetItemLast)) != null && Manager.CheckIsCustomNullItem(itemStack = lastSetItems.getInventory().getItem(index))) {
                        lastSetItems.setItem(index, itemNeedMove);
                        isMovedItemNeedMove = true;
                    }
                }
                if (!isMovedItemNeedMove) {
                    int freeSlot = util.GetFreeSlotInventory((Inventory)pi, true);
                    if (freeSlot != -1) {
                        pi.setItem(freeSlot, itemNeedMove);
                        isMovedItemNeedMove = true;
                    } else {
                        p.sendMessage(myConfig.i().lang.notEnoughSpaceForItems);
                        return false;
                    }
                }
            }
            this.inventory.setItem(index, Manager.defaultInventorySetItems.getContents()[index]);
            ItemMeta itemMeta = itemUse.getItemMeta();
            PersistentDataContainer container = itemMeta.getPersistentDataContainer();
            container.set(DataPersistent.setItemLast, PersistentDataType.STRING, (Object)this.title);
            itemUse.setItemMeta(itemMeta);
            util.setItemEquipOnPlayer(p, setItemType, itemUse);
            return true;
        }
        return false;
    }

    public boolean UseAll(Player p) {
        if (SetItemsEventHandler.coolDownSwapSetItems.containsKey(p.getName())) {
            if (SetItemsEventHandler.coolDownSwapSetItems.get(p.getName()) > System.currentTimeMillis()) {
                Long timeleft = SetItemsEventHandler.coolDownSwapSetItems.get(p.getName()) - System.currentTimeMillis();
                p.sendMessage(myConfig.i().lang.coolDownMessage.replace("{cooldown}", timeleft.toString()));
                return false;
            }
            SetItemsEventHandler.coolDownSwapSetItems.remove(p.getName());
        }
        int i = 0;
        while (i < 6) {
            this.UseItem(p, SetItemType.values()[i]);
            ++i;
        }
        SetItemsEventHandler.coolDownSwapSetItems.put(p.getName(), System.currentTimeMillis() + (long)myConfig.i().swapSetItemCoolDown);
        return true;
    }

    public ItemStack getItem(int index) {
        ItemStack itemStack = this.inventory.getItem(index);
        return itemStack;
    }

    public boolean setItem(int index, ItemStack itemStack) {
        this.inventory.setItem(index, itemStack);
        return false;
    }

    public boolean SaveAll(Player p) {
        PlayerInventory pi = p.getInventory();
        int i = 0;
        while (i < 6) {
            block3: {
                ItemStack itemEquip;
                SetItemType setItemType;
                block4: {
                    setItemType = SetItemType.values()[i];
                    itemEquip = util.getItemEquipOnPlayer(p, setItemType);
                    if (util.isNullItem(itemEquip)) break block3;
                    ItemStack itemInSetItems = this.inventory.getItem(i);
                    if (Manager.CheckIsCustomNullItem(itemInSetItems)) break block4;
                    int freeSlot = util.GetFreeSlotInventory((Inventory)pi, true);
                    if (freeSlot == -1) break block3;
                    pi.setItem(freeSlot, itemInSetItems);
                    Swapper.Debug("debug");
                }
                util.setItemEquipOnPlayer(p, setItemType, null);
                this.inventory.setItem(i, itemEquip);
            }
            ++i;
        }
        return false;
    }

    public boolean TakeAll(Player p) {
        int i = 0;
        while (i < 6) {
            ItemStack itemInSet = this.inventory.getItem(i);
            if (!Manager.CheckIsCustomNullItem(itemInSet)) {
                int freeSlot = util.GetFreeSlotInventory((Inventory)p.getInventory(), true);
                if (freeSlot != -1) {
                    p.getInventory().setItem(freeSlot, itemInSet);
                    this.inventory.setItem(i, Manager.defaultInventorySetItems.getContents()[i]);
                } else {
                    p.sendMessage(myConfig.i().lang.notEnoughSpaceForItems);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public ItemStack moveItemToPlayer(Player p, SetItemType type) {
        if (type == SetItemType.TakeAll) {
            return null;
        }
        ItemStack item = this.inventory.getItem(type.ordinal());
        if (item == null) {
            return null;
        }
        if (type == SetItemType.MainHand) {
            Swapper.Debug("getHeldItemSlot: " + p.getInventory().getHeldItemSlot());
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack[] getContents() {
        return this.inventory.getContents();
    }
}

