/*
 * Decompiled with CFR 0.152.
 */
package com.rot4tion.set_items.Handler;

import com.rot4tion.Swapper;
import com.rot4tion.set_items.DataManager.SetItemsManager;
import com.rot4tion.set_items.Enum.SetItemType;
import com.rot4tion.set_items.Handler.CommandSetItems;
import com.rot4tion.set_items.Manager;
import com.rot4tion.set_items.templates.DataSetItems;
import com.rot4tion.set_items.templates.SetItems;
import com.rot4tion.template.myConfig;
import com.rot4tion.util;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetItemsEventHandler
implements Listener {
    public static Map<String, Long> coolDownSwapSetItems = new HashMap<String, Long>();

    public SetItemsEventHandler() {
        Swapper.i.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Swapper.i);
        Swapper.i.getCommand("setitem").setExecutor((CommandExecutor)new CommandSetItems());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        DataSetItems dataSetItems;
        Player p = e.getEntity();
        if (myConfig.i().dropItemsOnDeath && (dataSetItems = SetItemsManager.getDataSetItemsByPlayer(p)) != null) {
            for (SetItems setItems : dataSetItems.getSetItemsList()) {
                Inventory inventory = setItems.getInventory();
                int i = 0;
                while (i < inventory.getContents().length) {
                    ItemStack itemStack = inventory.getItem(i);
                    if (!Manager.CheckIsCustomNullItem(itemStack)) {
                        inventory.setItem(i, Manager.defaultInventorySetItems.getItem(i));
                        p.getWorld().dropItem(p.getLocation().add(0.0, 1.0, 0.0), itemStack);
                    }
                    ++i;
                }
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        SetItemsManager.LoadDataPlayerJoin(p);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Swapper.Debug("onPlayerQuit");
        Player p = e.getPlayer();
        SetItemsManager.SaveDataPlayerLeave(p);
    }

    @EventHandler
    public void onInventory(InventoryEvent e) {
        Swapper.Debug("Inventory");
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent e) {
        Swapper.Debug("InventoryMoveItemEvent");
    }

    public int GetAutoIndexItem(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.HAND) {
            return SetItemType.MainHand.ordinal();
        }
        if (equipmentSlot == EquipmentSlot.OFF_HAND) {
            return SetItemType.LeftHand.ordinal();
        }
        if (equipmentSlot == EquipmentSlot.HEAD) {
            return SetItemType.Helmet.ordinal();
        }
        if (equipmentSlot == EquipmentSlot.CHEST) {
            return SetItemType.Chestplate.ordinal();
        }
        if (equipmentSlot == EquipmentSlot.LEGS) {
            return SetItemType.Leggings.ordinal();
        }
        if (equipmentSlot == EquipmentSlot.FEET) {
            return SetItemType.Boots.ordinal();
        }
        return -1;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        InventoryAction action = e.getAction();
        Swapper.Debug("InventoryClickEvent:  -action:" + e.getAction() + " -getTitle:" + util.unHideString(e.getView().getTitle()) + " -getHotbarButton:" + e.getHotbarButton() + " -getClick:" + e.getClick() + " -getSlot:" + e.getSlot() + " -getRawSlot:" + e.getRawSlot() + " -getCurrentItem:" + e.getCurrentItem() + " -getResult:" + e.getResult() + " -getSlotType:" + e.getSlotType() + " -getCursor:" + e.getCursor());
        if (!e.getView().getTitle().endsWith(Manager.suffixInventorySetItems)) {
            return;
        }
        if (e.getAction() == InventoryAction.NOTHING) {
            Swapper.Debug("InventoryAction.NOTHING");
            return;
        }
        Inventory invSetItems = p.getOpenInventory().getTopInventory();
        Inventory invPlayer = p.getOpenInventory().getBottomInventory();
        int rawSlot = e.getRawSlot();
        ItemStack curItem = e.getCurrentItem();
        ItemStack cursorItem = e.getCursor();
        if (curItem != null && Manager.CheckIsCustomNullItem(curItem)) {
            Swapper.Debug("Cancel Event");
            e.setCancelled(true);
        }
        if (rawSlot <= 1) {
            if (action == InventoryAction.SWAP_WITH_CURSOR) {
                ItemStack itemInSlot = invSetItems.getItem(rawSlot);
                if (Manager.CheckIsCustomNullItem(itemInSlot)) {
                    p.setItemOnCursor(null);
                } else {
                    Swapper.Debug("  p.setItemOnCursor(itemInAutoSlot);" + itemInSlot);
                    p.setItemOnCursor(itemInSlot);
                }
                invSetItems.setItem(rawSlot, cursorItem);
                e.setCancelled(true);
            }
        } else if (rawSlot >= 2 && rawSlot <= 5) {
            if (action == InventoryAction.SWAP_WITH_CURSOR) {
                int autoSlot = this.GetAutoIndexItem(cursorItem.getType().getEquipmentSlot());
                if (autoSlot == -1) {
                    Swapper.Debug("autoSlot == -1");
                    return;
                }
                ItemStack itemInAutoSlot = invSetItems.getItem(autoSlot).clone();
                if (Manager.CheckIsCustomNullItem(itemInAutoSlot)) {
                    p.setItemOnCursor(null);
                } else {
                    Swapper.Debug("  p.setItemOnCursor(itemInAutoSlot);" + itemInAutoSlot);
                    p.setItemOnCursor(itemInAutoSlot);
                }
                invSetItems.setItem(autoSlot, cursorItem);
                e.setCancelled(true);
            }
        } else if (rawSlot == 6) {
            if (rawSlot == 6) {
                Swapper.Debug("Take all");
                int i = 0;
                while (i < 6) {
                    int freeSlot;
                    ItemStack itemInSet = invSetItems.getItem(i);
                    if (!Manager.CheckIsCustomNullItem(itemInSet) && (freeSlot = util.GetFreeSlotInventory((Inventory)p.getInventory(), true)) != -1) {
                        invPlayer.setItem(freeSlot, itemInSet);
                        invSetItems.setItem(i, null);
                    }
                    ++i;
                }
            }
        } else if (rawSlot >= 7 && rawSlot <= 8) {
            DataSetItems dataSetItems = SetItemsManager.getDataSetItemsByPlayer(p);
            if (dataSetItems == null) {
                Swapper.Debug("page data null");
            }
            int indexSetItem = -1;
            int i = 0;
            while (i < dataSetItems.setItemsList.size()) {
                SetItems setItems = dataSetItems.setItemsList.get(i);
                if (setItems.getTitle() == e.getView().getTitle()) {
                    indexSetItem = i;
                    break;
                }
                ++i;
            }
            if (indexSetItem == -1) {
                Swapper.Debug("indexSetItem == -1");
                return;
            }
            if (rawSlot == 7) {
                Swapper.Debug("Pre page");
                if (indexSetItem == 0) {
                    indexSetItem = dataSetItems.setItemsList.size();
                }
                p.openInventory(dataSetItems.setItemsList.get(indexSetItem - 1).getInventory());
            } else if (rawSlot == 8) {
                Swapper.Debug("Next page");
                if (indexSetItem == dataSetItems.setItemsList.size() - 1) {
                    indexSetItem = -1;
                }
                p.openInventory(dataSetItems.setItemsList.get(indexSetItem + 1).getInventory());
            }
        } else if (rawSlot > 8 && action == InventoryAction.MOVE_TO_OTHER_INVENTORY && e.getClick() == ClickType.SHIFT_LEFT) {
            int autoSlot = this.GetAutoIndexItem(curItem.getType().getEquipmentSlot());
            if (autoSlot == -1) {
                Swapper.Debug("autoSlot == -1");
                return;
            }
            ItemStack itemInAutoSlot = invSetItems.getItem(autoSlot).clone();
            if (Manager.CheckIsCustomNullItem(itemInAutoSlot)) {
                invPlayer.setItem(e.getSlot(), null);
            } else {
                invPlayer.setItem(e.getSlot(), itemInAutoSlot);
            }
            invSetItems.setItem(autoSlot, curItem);
            e.setCancelled(true);
        }
        Swapper.Debug("Update null item");
        this.UpdateInventoryViewNextTick(p);
    }

    public void UpdateInventoryViewNextTick(Player p) {
        final Inventory invSetItems = p.getOpenInventory().getTopInventory();
        new BukkitRunnable(){

            public void run() {
                int i = 0;
                while (i < 6) {
                    ItemStack itemStack = invSetItems.getItem(i);
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        invSetItems.setItem(i, Manager.defaultInventorySetItems.getContents()[i]);
                    }
                    ++i;
                }
            }
        }.runTaskLater((Plugin)Swapper.i, 1L);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Action a = e.getAction();
    }
}

