/*
 * Decompiled with CFR 0.152.
 */
package com.rot4tion.set_items.DataManager;

import com.rot4tion.Swapper;
import com.rot4tion.set_items.Manager;
import com.rot4tion.set_items.templates.DataSetItems;
import com.rot4tion.set_items.templates.SetItems;
import com.rot4tion.template.myConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SetItemsManager {
    public static List<DataSetItems> dataSetItemsList = new ArrayList<DataSetItems>();
    public static final String pathPlugins = "plugins/Swapper/";
    public static final String pathData = "plugins/Swapper/Data/";
    public static final String pathDataPlayer = "plugins/Swapper/Data//SetItems";
    public static final String suffix = ".yml";

    public static boolean SaveAllData() {
        if (dataSetItemsList.size() > 0) {
            for (DataSetItems dataSetItems : dataSetItemsList) {
                SetItemsManager.SaveDataSetItems(dataSetItems);
            }
        }
        return false;
    }

    public static boolean LoadAllData() {
        Swapper.Debug("LoadAllData null");
        return false;
    }

    public static DataSetItems createSetItems(Player p, String title) {
        DataSetItems data = SetItemsManager.getDataSetItemsByPlayer(p);
        if (data != null) {
            if (data.getSetItemsByTitle(title) != null) {
                return data;
            }
            if (data.setItemsList.size() < myConfig.i().maxSetItems || myConfig.i().maxSetItems == -1) {
                data.setItemsList.add(new SetItems(title, Manager.createInventoryDefaultSetItems(p, title)));
                return data;
            }
            p.sendMessage(myConfig.i().lang.reachedLimitSetItems);
            return data;
        }
        ArrayList<SetItems> defaultSetitem = new ArrayList<SetItems>();
        defaultSetitem.add(new SetItems(title, Manager.createInventoryDefaultSetItems(p, title)));
        data = new DataSetItems(p, defaultSetitem);
        dataSetItemsList.add(data);
        return data;
    }

    public static DataSetItems getDataSetItemsByPlayer(Player p) {
        for (DataSetItems dataSetItems : dataSetItemsList) {
            if (dataSetItems.p != p) continue;
            return dataSetItems;
        }
        return null;
    }

    public static SetItems getSetItemsByTitle(Player p, String title) {
        DataSetItems data = SetItemsManager.getDataSetItemsByPlayer(p);
        if (data == null) {
            p.sendMessage("You need create set items first");
            return null;
        }
        SetItems setitems = data.getSetItemsByTitle(title);
        if (setitems == null) {
            p.sendMessage(myConfig.i().lang.setItemsNotFound);
            Swapper.Debug("setitems null");
            return null;
        }
        return setitems;
    }

    public static boolean LoadDataPlayerJoin(Player p) {
        DataSetItems dataSetItems = SetItemsManager.LoadSetItemsByPlayer(p);
        if (dataSetItems != null) {
            dataSetItemsList.add(dataSetItems);
            Swapper.Debug(String.valueOf(p.getName()) + ": Load SetItems Complete");
            return true;
        }
        Swapper.Debug(String.valueOf(p.getName()) + ": Load SetItems Fail");
        return false;
    }

    public static boolean SaveDataPlayerLeave(Player p) {
        return SetItemsManager.SaveAndRemoveSetItemByPlayer(p);
    }

    public static DataSetItems LoadSetItemsByPlayer(Player p) {
        String path = "plugins/Swapper/Data//SetItems/" + p.getUniqueId() + suffix;
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)f);
        ArrayList keys = new ArrayList(c.getKeys(true));
        ArrayList<SetItems> listSetItems = new ArrayList<SetItems>();
        for (String title : keys) {
            ItemStack[] contents = ((List)c.get(title)).toArray(new ItemStack[0]);
            int i = 0;
            while (i < contents.length) {
                ItemStack itemStack = contents[i];
                if (itemStack == null) {
                    contents[i] = Manager.defaultInventorySetItems.getItem(i);
                }
                ++i;
            }
            Inventory inventory = Manager.createInventoryDefaultSetItems(p, title);
            inventory.setContents(contents);
            listSetItems.add(new SetItems(title, inventory));
        }
        DataSetItems dataSetItems = new DataSetItems(p, listSetItems);
        return dataSetItems;
    }

    public static boolean SaveDataSetItems(DataSetItems dataSetItems) {
        String path = "plugins/Swapper/Data//SetItems/" + dataSetItems.getPlayerUUID() + suffix;
        File f = new File(path);
        f.delete();
        if (dataSetItems.setItemsList.size() == 0) {
            return false;
        }
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)f);
        for (SetItems setItems : dataSetItems.setItemsList) {
            ItemStack[] arrItemStack = setItems.getInventory().getContents();
            int i = 0;
            while (i < arrItemStack.length) {
                ItemStack itemStack = arrItemStack[i];
                if (Manager.CheckIsCustomNullItem(itemStack)) {
                    arrItemStack[i] = null;
                }
                ++i;
            }
            c.set(setItems.getTitle(), (Object)arrItemStack);
        }
        try {
            c.save(f);
            Swapper.Debug("SaveDataSetItems: " + dataSetItems.p.getName() + " Complete");
            return true;
        }
        catch (IOException e) {
            Swapper.Debug("SaveDataSetItems: " + dataSetItems.p.getName() + " Fail");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean SaveAndRemoveSetItemByPlayer(Player p) {
        if (dataSetItemsList.size() == 0) {
            return false;
        }
        List filter = dataSetItemsList.stream().filter(x -> x.p == p).collect(Collectors.toList());
        if (filter.size() > 0) {
            DataSetItems data = (DataSetItems)filter.get(0);
            SetItemsManager.SaveDataSetItems(data);
            dataSetItemsList.remove(data);
        } else {
            Swapper.LOGGER.warning(String.valueOf(p.getName()) + " SaveSetItemByPlayer data not found");
        }
        return false;
    }
}

