/*
 * Decompiled with CFR 0.152.
 */
package com.rot4tion.auto_tools;

import com.google.common.collect.ImmutableMap;
import com.rot4tion.auto_tools.Enum.ToolType;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ToolUtil {
    private static ImmutableMap<String, ToolType> TOOL_MATERIAL_MAPPING;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Material.COCOA.name(), (Object)ToolType.AXE).put((Object)Material.LECTERN.name(), (Object)ToolType.AXE).put((Object)Material.JACK_O_LANTERN.name(), (Object)ToolType.AXE).put((Object)Material.PUMPKIN.name(), (Object)ToolType.AXE).put((Object)Material.MELON.name(), (Object)ToolType.AXE).put((Object)Material.BOOKSHELF.name(), (Object)ToolType.AXE).put((Object)Material.CHEST.name(), (Object)ToolType.AXE).put((Object)Material.CRAFTING_TABLE.name(), (Object)ToolType.AXE).put((Object)Material.DAYLIGHT_DETECTOR.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.OAK_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.OAK_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_FENCE.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_FENCE_GATE.name(), (Object)ToolType.AXE).put((Object)Material.MUSHROOM_STEM.name(), (Object)ToolType.AXE).put((Object)Material.BROWN_MUSHROOM_BLOCK.name(), (Object)ToolType.AXE).put((Object)Material.RED_MUSHROOM_BLOCK.name(), (Object)ToolType.AXE).put((Object)Material.JUKEBOX.name(), (Object)ToolType.AXE).put((Object)Material.LADDER.name(), (Object)ToolType.AXE).put((Object)Material.NOTE_BLOCK.name(), (Object)ToolType.AXE).put((Object)Material.TRAPPED_CHEST.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.OAK_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_BUTTON.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.OAK_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_PRESSURE_PLATE.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.OAK_SLAB.name(), (Object)ToolType.AXE).put((Object)Material.ACACIA_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.BIRCH_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.DARK_OAK_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.JUNGLE_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.OAK_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.SPRUCE_STAIRS.name(), (Object)ToolType.AXE).put((Object)Material.REDSTONE_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.BREWING_STAND.name(), (Object)ToolType.PICKAXE).put((Object)Material.CAULDRON.name(), (Object)ToolType.PICKAXE).put((Object)Material.IRON_BARS.name(), (Object)ToolType.PICKAXE).put((Object)Material.IRON_DOOR.name(), (Object)ToolType.PICKAXE).put((Object)Material.IRON_TRAPDOOR.name(), (Object)ToolType.PICKAXE).put((Object)Material.HOPPER.name(), (Object)ToolType.PICKAXE).put((Object)Material.HEAVY_WEIGHTED_PRESSURE_PLATE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LIGHT_WEIGHTED_PRESSURE_PLATE.name(), (Object)ToolType.PICKAXE).put((Object)Material.IRON_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.LAPIS_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.DIAMOND_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.EMERALD_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.GOLD_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.SHULKER_BOX.name(), (Object)ToolType.PICKAXE).put((Object)Material.ANDESITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.COAL_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.QUARTZ_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.COAL_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.CHISELED_STONE_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.CRACKED_STONE_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.MOSSY_STONE_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.COBBLESTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.BLACK_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.BLUE_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.BROWN_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.CYAN_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.GRAY_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.GREEN_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LIGHT_BLUE_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LIGHT_GRAY_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LIME_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.MAGENTA_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.ORANGE_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.PINK_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.PURPLE_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.WHITE_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.YELLOW_CONCRETE.name(), (Object)ToolType.PICKAXE).put((Object)Material.DARK_PRISMARINE.name(), (Object)ToolType.PICKAXE).put((Object)Material.DARK_PRISMARINE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.DARK_PRISMARINE_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.DIORITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.DISPENSER.name(), (Object)ToolType.PICKAXE).put((Object)Material.DROPPER.name(), (Object)ToolType.PICKAXE).put((Object)Material.ENCHANTING_TABLE.name(), (Object)ToolType.PICKAXE).put((Object)Material.COBBLESTONE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.COBBLESTONE_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.END_STONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.ENDER_CHEST.name(), (Object)ToolType.PICKAXE).put((Object)Material.FURNACE.name(), (Object)ToolType.PICKAXE).put((Object)Material.GRANITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.MOSSY_COBBLESTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_BRICK.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_BRICK_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_BRICK_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHERRACK.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_QUARTZ_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.POLISHED_ANDESITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.POLISHED_DIORITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.POLISHED_GRANITE.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_SANDSTONE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_SANDSTONE_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.SANDSTONE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.SANDSTONE_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.CHISELED_RED_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.CHISELED_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.CUT_RED_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.CUT_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.SMOOTH_QUARTZ.name(), (Object)ToolType.PICKAXE).put((Object)Material.SMOOTH_RED_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.SMOOTH_SANDSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.SMOOTH_STONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.SPAWNER.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.BRICK_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_BRICK_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.BRICK_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_BRICK_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_BUTTON.name(), (Object)ToolType.PICKAXE).put((Object)Material.TERRACOTTA.name(), (Object)ToolType.PICKAXE).put((Object)Material.STONE_PRESSURE_PLATE.name(), (Object)ToolType.PICKAXE).put((Object)Material.IRON_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LAPIS_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.DIAMOND_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.EMERALD_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.GOLD_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.REDSTONE_ORE.name(), (Object)ToolType.PICKAXE).put((Object)Material.OBSIDIAN.name(), (Object)ToolType.PICKAXE).put((Object)Material.ACACIA_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.BIRCH_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.DARK_OAK_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.JUNGLE_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.OAK_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.SPRUCE_LEAVES.name(), (Object)ToolType.SHEARS).put((Object)Material.COBWEB.name(), (Object)ToolType.SWORD).put((Object)Material.CLAY.name(), (Object)ToolType.SHOVEL).put((Object)Material.DIRT.name(), (Object)ToolType.SHOVEL).put((Object)Material.COARSE_DIRT.name(), (Object)ToolType.SHOVEL).put((Object)Material.FARMLAND.name(), (Object)ToolType.SHOVEL).put((Object)Material.GRASS_BLOCK.name(), (Object)ToolType.SHOVEL).put((Object)Material.GRASS_PATH.name(), (Object)ToolType.SHOVEL).put((Object)Material.GRAVEL.name(), (Object)ToolType.SHOVEL).put((Object)Material.MYCELIUM.name(), (Object)ToolType.SHOVEL).put((Object)Material.PODZOL.name(), (Object)ToolType.SHOVEL).put((Object)Material.RED_SAND.name(), (Object)ToolType.SHOVEL).put((Object)Material.SAND.name(), (Object)ToolType.SHOVEL).put((Object)Material.SOUL_SAND.name(), (Object)ToolType.SHOVEL).put((Object)Material.SNOW.name(), (Object)ToolType.SHOVEL).put((Object)Material.SNOW_BLOCK.name(), (Object)ToolType.SHOVEL).put((Object)Material.VINE.name(), (Object)ToolType.SWORD).put((Object)Material.BLACK_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.BLUE_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.BROWN_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.CYAN_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.GRAY_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.GREEN_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.LIGHT_BLUE_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.LIGHT_GRAY_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.LIME_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.MAGENTA_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.ORANGE_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.PINK_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.PURPLE_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.RED_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.WHITE_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL).put((Object)Material.ANCIENT_DEBRIS.name(), (Object)ToolType.PICKAXE).put((Object)Material.BASALT.name(), (Object)ToolType.PICKAXE).put((Object)Material.BLACKSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.BLACKSTONE_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.BLACKSTONE_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHERITE_BLOCK.name(), (Object)ToolType.PICKAXE).put((Object)Material.CHAIN.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_BRICK_FENCE.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_NETHER_BRICK_STAIRS.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_NETHER_BRICK_SLAB.name(), (Object)ToolType.PICKAXE).put((Object)Material.RED_NETHER_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.NETHER_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.CRYING_OBSIDIAN.name(), (Object)ToolType.PICKAXE).put((Object)Material.GILDED_BLACKSTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.LODESTONE.name(), (Object)ToolType.PICKAXE).put((Object)Material.QUARTZ_BRICKS.name(), (Object)ToolType.PICKAXE).put((Object)Material.RESPAWN_ANCHOR.name(), (Object)ToolType.PICKAXE).put((Object)Material.CAMPFIRE.name(), (Object)ToolType.AXE).put((Object)Material.SOUL_CAMPFIRE.name(), (Object)ToolType.AXE).put((Object)Material.LANTERN.name(), (Object)ToolType.PICKAXE).put((Object)Material.SOUL_LANTERN.name(), (Object)ToolType.PICKAXE).put((Object)Material.SOUL_SOIL.name(), (Object)ToolType.SHOVEL).put((Object)Material.YELLOW_CONCRETE_POWDER.name(), (Object)ToolType.SHOVEL);
        builder.put((Object)"DRIPSTONE_BLOCK", (Object)ToolType.PICKAXE).put((Object)"POINTED_DRIPSTONE", (Object)ToolType.PICKAXE).put((Object)"LIGHTNING_ROD", (Object)ToolType.PICKAXE).put((Object)"TUFF", (Object)ToolType.PICKAXE).put((Object)"MOSS_BLOCK", (Object)ToolType.HOE).put((Object)"MOSS_CARPET", (Object)ToolType.HOE).put((Object)"SCULK_SENSOR", (Object)ToolType.HOE).put((Object)"GLOW_LICHEN", (Object)ToolType.SHEARS);
        builder.put((Object)"MUDDY_MANGROVE_ROOTS", (Object)ToolType.AXE).put((Object)"MANGROVE_ROOTS", (Object)ToolType.AXE);
        for (Material material : Tag.LOGS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.ANVIL.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.PICKAXE);
        }
        for (Material material : Tag.BEDS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.BEEHIVES.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.DOORS.getValues()) {
            if (material.toString().contains("IRON")) continue;
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.TRAPDOORS.getValues()) {
            if (material.toString().contains("IRON")) continue;
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.PLANKS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.RAILS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.PICKAXE);
        }
        for (Material material : Tag.ICE.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.PICKAXE);
        }
        for (Material material : Tag.SIGNS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.AXE);
        }
        for (Material material : Tag.WALLS.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.PICKAXE);
        }
        for (Material material : Tag.WOOL.getValues()) {
            builder.put((Object)material.name(), (Object)ToolType.SHEARS);
        }
        TOOL_MATERIAL_MAPPING = builder.build();
    }

    public static ToolType getMostAppropriateTool(Material material) {
        ToolType toolType = (ToolType)((Object)TOOL_MATERIAL_MAPPING.getOrDefault((Object)material.name(), (Object)ToolType.NONE));
        if (toolType != ToolType.NONE) {
            return toolType;
        }
        if (material.name().endsWith("_LEAVES")) {
            return ToolType.SHEARS;
        }
        if (material.name().endsWith("BASALT")) {
            return ToolType.PICKAXE;
        }
        if (material.name().endsWith("_LOG")) {
            return ToolType.PICKAXE;
        }
        if (material.name().endsWith("_PLANKS")) {
            return ToolType.AXE;
        }
        if (material.name().endsWith("_WOOD")) {
            return ToolType.AXE;
        }
        if (material.name().startsWith("MUD_")) {
            return ToolType.PICKAXE;
        }
        if (material.name().startsWith("SCULK")) {
            return ToolType.HOE;
        }
        if (material.name().contains("TERRACOTTA")) {
            return ToolType.PICKAXE;
        }
        if (material.name().contains("AMETHYST")) {
            return ToolType.PICKAXE;
        }
        if (material.name().contains("COPPER")) {
            return ToolType.PICKAXE;
        }
        if (material.name().contains("DEEPSLATE")) {
            return ToolType.PICKAXE;
        }
        if (material.name().contains("MANGROVE")) {
            return ToolType.AXE;
        }
        return toolType;
    }

    public static int getDurabilityLeft(ItemStack item) {
        ItemMeta meta;
        if (item != null && item.hasItemMeta() && (meta = item.getItemMeta()) instanceof Damageable) {
            return item.getType().getMaxDurability() - ((Damageable)meta).getDamage();
        }
        return -1;
    }
}

