/*
 * Decompiled with CFR 0.152.
 */
package de.djd001.adminmode;

import de.djd001.adminmode.AdminConfigExecutor;
import de.djd001.adminmode.AdminExecutor;
import de.djd001.adminmode.AdminListener;
import de.djd001.adminmode.AdminTpExecutor;
import de.djd001.adminmode.InventorySaveLoader;
import de.djd001.adminmode.Util;
import de.djd001.adminmode.VanishExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public class Main
extends JavaPlugin {
    private boolean ci;
    private boolean tpback;
    boolean dcv;
    boolean dca;
    boolean hv;
    boolean ha;
    boolean intv;
    boolean inta;
    private HashMap<UUID, ItemStack[]> inv = new HashMap();
    private HashMap<UUID, ItemStack[]> arm = new HashMap();
    private HashMap<UUID, Collection<PotionEffect>> pot = new HashMap();
    private HashMap<UUID, GameMode> mode = new HashMap();
    private HashMap<UUID, Location> location = new HashMap();
    private List<UUID> admin = new ArrayList<UUID>();
    private List<UUID> vanish = new ArrayList<UUID>();
    public Collection<PotionEffect> effect = new ArrayList<PotionEffect>();
    public HashMap<Integer, ItemStack> items = new HashMap();
    public HashMap<Material, String> commands = new HashMap();
    public String toAdmin;
    public String fromAdmin;
    public String toVanish;
    public String fromVanish;
    private InventorySaveLoader sl;

    public void onEnable() {
        super.onEnable();
        this.setupConfig();
        this.loadCommands();
        this.sl = new InventorySaveLoader(this);
        this.sl.load();
        Bukkit.getPluginManager().registerEvents((Listener)new AdminListener(this), (Plugin)this);
        this.getCommand("admin").setExecutor((CommandExecutor)new AdminExecutor(this));
        this.getCommand("atp").setExecutor((CommandExecutor)new AdminTpExecutor(this));
        this.getCommand("vanish").setExecutor((CommandExecutor)new VanishExecutor(this));
        this.getCommand("aconfig").setExecutor((CommandExecutor)new AdminConfigExecutor(this));
        System.out.println("[AdminMode] Enabled AdminMode by djd001");
    }

    public void onDisable() {
        super.onDisable();
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player pl = playerArray[n2];
            if (this.isAdmin(pl)) {
                this.toggleAdmin(pl);
            }
            ++n2;
        }
    }

    public void toggleAdmin(Player p) {
        UUID u = p.getUniqueId();
        if (this.isAdmin(p)) {
            if (this.ci) {
                p.getInventory().setContents(this.inv.get(u));
                p.getInventory().setArmorContents(this.arm.get(u));
                for (PotionEffect po : p.getActivePotionEffects()) {
                    p.removePotionEffect(po.getType());
                }
                p.addPotionEffects(this.pot.get(u));
            }
            if (this.tpback) {
                p.teleport(this.location.get(u));
            }
            p.setGameMode(this.mode.get(u));
            this.setVanish(p, false);
            this.inv.remove(u);
            this.arm.remove(u);
            this.pot.remove(u);
            this.mode.remove(u);
            this.admin.remove(u);
            this.location.remove(u);
        } else {
            this.inv.put(u, p.getInventory().getContents());
            this.arm.put(u, p.getInventory().getArmorContents());
            this.pot.put(u, p.getActivePotionEffects());
            this.mode.put(u, p.getGameMode());
            this.location.put(u, p.getLocation());
            this.admin.add(u);
            this.setVanish(p, true);
            if (this.ci) {
                p.getInventory().clear();
                p.getInventory().setArmorContents(new ItemStack[4]);
                for (PotionEffect po : p.getActivePotionEffects()) {
                    p.removePotionEffect(po.getType());
                }
                Iterator<Object> iterator = this.items.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i < 100) {
                        p.getInventory().setItem(i, this.items.get(i));
                        continue;
                    }
                    if (i == 101) {
                        p.getInventory().setBoots(this.items.get(i));
                        continue;
                    }
                    if (i == 102) {
                        p.getInventory().setLeggings(this.items.get(i));
                        continue;
                    }
                    if (i == 103) {
                        p.getInventory().setChestplate(this.items.get(i));
                        continue;
                    }
                    if (i != 104) continue;
                    p.getInventory().setHelmet(this.items.get(i));
                }
                p.addPotionEffects(this.effect);
            }
            p.setGameMode(GameMode.CREATIVE);
        }
    }

    public boolean isAdmin(Player p) {
        return this.admin.contains(p.getUniqueId());
    }

    public boolean isVanish(Player p) {
        return this.vanish.contains(p.getUniqueId());
    }

    public void setVanish(Player p, boolean vanish) {
        UUID u = p.getUniqueId();
        if (!this.vanish.contains(u)) {
            if (vanish) {
                this.vanish.add(u);
                this.vanish(p);
            }
        } else if (!vanish) {
            this.vanish.remove(u);
            this.vanish(p);
        }
    }

    public void vanish(Player p) {
        boolean b = this.vanish.contains(p.getUniqueId());
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player pl = playerArray[n2];
            if (b && pl.canSee(p) && !pl.hasPermission("adminmode.vanish.see")) {
                pl.hidePlayer(p);
            } else if (!(b && !pl.hasPermission("adminmode.vanish.see") || pl.canSee(p))) {
                pl.showPlayer(p);
            }
            ++n2;
        }
    }

    private void setupConfig() {
        this.saveDefaultConfig();
        this.ci = this.getConfig().getBoolean("options.change_inventory", true);
        this.dcv = this.getConfig().getBoolean("options.drop_collect_vanish", true);
        this.hv = this.getConfig().getBoolean("options.hit_vanish", true);
        this.intv = this.getConfig().getBoolean("options.interact_vanish", false);
        this.dca = this.getConfig().getBoolean("options.drop_collect_admin", false);
        this.ha = this.getConfig().getBoolean("options.hit_admin", false);
        this.inta = this.getConfig().getBoolean("options.interact_admin", false);
        this.tpback = this.getConfig().getBoolean("options.tp_back", false);
        this.toAdmin = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.to_admin", "&4You are now in admin mode!"));
        this.fromAdmin = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.from_admin", "&aYou are now in player mode!"));
        this.toVanish = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.to_vanish", "&4You are now in admin mode!"));
        this.fromVanish = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.from_vanish", "&aYou are now in player mode!"));
    }

    private void loadCommands() {
        int i = 0;
        if (this.getConfig().contains("commands")) {
            for (String c : this.getConfig().getConfigurationSection("commands").getKeys(false)) {
                String t = this.getConfig().getString("commands." + c);
                Material m = Util.toMaterial(c);
                if (m != null) {
                    this.commands.put(m, t);
                    ++i;
                    continue;
                }
                System.out.println("[AdminMode] Unknown material " + c);
            }
        }
        System.out.println("[AdminMode] Loaded " + i + " commands from the config.");
    }

    public boolean changeInventory() {
        return this.ci;
    }

    public InventorySaveLoader getSaveLoader() {
        return this.sl;
    }
}

