/*
 * Decompiled with CFR 0.152.
 */
package com.blockbreakreward;

import com.blockbreakreward.ConfigHandler.ConfigHandler;
import com.blockbreakreward.ConfigHandler.ConfigTemplate;
import com.blockbreakreward.EventsHandler.BlockBreakEventHandler;
import com.blockbreakreward.EventsHandler.CommandHandler;
import com.blockbreakreward.EventsHandler.InventoryEventHandler;
import com.blockbreakreward.EventsHandler.OnJoinHandler;
import com.blockbreakreward.EventsHandler.OnQuitHandler;
import com.blockbreakreward.EventsHandler.TabCompletion;
import com.blockbreakreward.GUI.LeaderboardManager;
import com.blockbreakreward.GUI.LeaderboardTemplate;
import com.blockbreakreward.MetricsLite;
import com.blockbreakreward.MyFunc;
import com.blockbreakreward.MySQLConnection.MySQLConnect;
import com.blockbreakreward.MySQLConnection.MySQLHandler;
import com.blockbreakreward.PlayerLoader.PlayerProcessor;
import com.blockbreakreward.PlayerLoader.PlayerTemplate;
import com.blockbreakreward.RewardLoader.RewardProcessor;
import com.blockbreakreward.RewardLoader.RewardTemplate;
import com.blockbreakreward.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Plugin
extends JavaPlugin {
    public static final Logger LOGGER = Logger.getLogger("BlockBreakReward");
    public static List<RewardTemplate> rewards;
    public static List<PlayerTemplate> players;
    public static String playerDataPath;
    public static String leaderboardFilePath;
    public static File[] playerDataFileList;
    public static Plugin plugin;
    public static ConfigTemplate configTemplate;
    PluginDescriptionFile pdf = this.getDescription();
    public static MySQLConnect mysql;

    public void onEnable() {
        this.saveDefaultConfig();
        this.CreateFolder("PlayerData");
        LeaderboardTemplate.updateLeaderboardTemplate();
        new MetricsLite((org.bukkit.plugin.Plugin)this, 16216);
        plugin = this;
        rewards = new ArrayList<RewardTemplate>();
        players = new ArrayList<PlayerTemplate>();
        MyFunc.SetDefaultConfigValue();
        ConfigHandler.UpdateConfigInstance();
        mysql = new MySQLConnect(this);
        playerDataFileList = new File("plugins/blockbreakreward/PlayerData").listFiles();
        if (!RewardProcessor.SaveRewardsList(this)) {
            Bukkit.getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)this);
            return;
        }
        new CommandHandler(this);
        LOGGER.info("Commands are registered");
        new BlockBreakEventHandler(this);
        LOGGER.info("Block Break Event is registered");
        new OnQuitHandler(this);
        LOGGER.info("Player Quit Event is registered");
        new OnJoinHandler(this);
        LOGGER.info("Player Join Event is registered");
        new TabCompletion(this);
        LOGGER.info("Tab Completion is registered");
        new InventoryEventHandler(this);
        LOGGER.info("Invetory Event Handler is registered");
        if (ConfigHandler.GetEnableMySQL()) {
            if (ConfigHandler.GetMySQLDatabaseName().isEmpty() || ConfigHandler.GetMySQLPassword().isEmpty() || ConfigHandler.GetMySQLPort() == null || ConfigHandler.GetMySQLUsername().isEmpty() || !ConfigHandler.GetEnableMySQL()) {
                LOGGER.info(ChatColor.YELLOW + "You're not using database, will use default settings");
            } else if (!(ConfigHandler.GetMySQLDatabaseName().isEmpty() || ConfigHandler.GetMySQLPassword().isEmpty() || ConfigHandler.GetMySQLPort() == null || ConfigHandler.GetMySQLUsername().isEmpty())) {
                mysql.connect();
                if (!mysql.isConnected()) {
                    LOGGER.info(ChatColor.RED + "MySQL Database wasn't setup correctly, please check again!");
                    this.getServer().getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)this);
                    return;
                }
            }
            LOGGER.info(ChatColor.GREEN + "Connect to dabase successfully");
        } else {
            LOGGER.info(ChatColor.YELLOW + "MySQL is set to false, will use default settings");
        }
        if (!mysql.isConnected()) {
            if (!PlayerProcessor.SavePlayerDataToList()) {
                Bukkit.getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)this);
                return;
            }
        } else if (mysql.isConnected() && ConfigHandler.GetEnableMySQL()) {
            MySQLHandler.LoadPlayerDataMySQLToList();
        }
        this.updateLeaderboardSchedule();
        new UpdateChecker(this, 104718).getVersion(version -> {
            if (this.pdf.getVersion().equals(version)) {
                LOGGER.info(ChatColor.YELLOW + "Block Break Reward is on");
                LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
                LOGGER.info(ChatColor.GRAY + " BlockBreakReward ");
                LOGGER.info(ChatColor.GRAY + "     Version " + ChatColor.RED + "v" + this.pdf.getVersion());
                LOGGER.info(ChatColor.GREEN + "     No update available");
                LOGGER.info(ChatColor.GRAY + " Plugin by " + ChatColor.GREEN + "" + this.pdf.getAuthors());
                LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
            } else {
                LOGGER.info(ChatColor.YELLOW + "Block Break Reward is on");
                LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
                LOGGER.info(ChatColor.GRAY + " BlockBreakReward ");
                LOGGER.info(ChatColor.GRAY + "     Version " + ChatColor.RED + "v" + this.pdf.getVersion());
                LOGGER.info(ChatColor.RED + "New version" + version + "is released");
                LOGGER.info(ChatColor.GRAY + " Plugin by " + ChatColor.GREEN + "" + this.pdf.getAuthors());
                LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
            }
        });
    }

    public void info(String version) {
        LOGGER.info(ChatColor.YELLOW + "Block Break Reward is on");
        LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
        LOGGER.info(ChatColor.GRAY + " BlockBreakReward ");
        LOGGER.info(ChatColor.GRAY + "     Version " + ChatColor.RED + "v" + this.pdf.getVersion());
        LOGGER.info(ChatColor.GRAY + " Plugin by " + ChatColor.GREEN + "" + this.pdf.getAuthors());
        LOGGER.info(ChatColor.GRAY + "+-----------------------------+");
    }

    public void onDisable() {
        MyFunc.SetDefaultConfigValue();
        if (mysql.isConnected()) {
            try {
                for (int x = 0; x < players.size(); ++x) {
                    if (!(Plugin.players.get((int)x).p != null & Plugin.players.get((int)x).minedAfterJoin > 0)) continue;
                    MySQLHandler.SavePlayerDataToMySQL(players.get(x), x);
                }
            }
            catch (Exception exception) {
                LOGGER.info(ChatColor.RED + "All players data can't be saved");
            }
            LOGGER.info(ChatColor.RED + "Block Break Reward is off");
        } else {
            try {
                for (int x = 0; x < players.size(); ++x) {
                    if (!(Plugin.players.get((int)x).p != null & Plugin.players.get((int)x).minedAfterJoin > 0)) continue;
                    PlayerProcessor.CreatePlayerFileAndSetValue(players.get(x), x);
                }
            }
            catch (Exception exception) {
                LOGGER.info(ChatColor.RED + "All players data can't be saved");
            }
            LOGGER.info(ChatColor.RED + "Block Break Reward is off");
        }
    }

    public void CreateFolder(String path) {
        String[] folders = path.split("/");
        String newPath = "";
        for (int x = 0; x < folders.length; ++x) {
            newPath = newPath + "/" + folders[x];
            File file = new File("plugins/blockbreakreward" + newPath);
            if (file.exists()) continue;
            file.mkdir();
        }
    }

    public static void CreateDefaultLeaderboardFile() {
        YamlConfiguration yaml;
        File leaderboard = new File(leaderboardFilePath);
        if (!leaderboard.exists()) {
            try {
                leaderboard.createNewFile();
            }
            catch (IOException e) {
                LOGGER.info(ChatColor.RED + "Can't create Leaderboard.yml");
                e.printStackTrace();
            }
        }
        if (!(yaml = YamlConfiguration.loadConfiguration((File)leaderboard)).contains("FillBackgroundWith")) {
            yaml.set("FillBackgroundWith", (Object)"BLACK_STAINED_GLASS_PANE");
        }
        if (!yaml.contains("UpdateEverySeconds")) {
            yaml.set("UpdateEverySeconds", (Object)7200);
        }
        if (!yaml.contains("LeaderboardTitle")) {
            yaml.set("LeaderboardTitle", (Object)"TOP MINER!");
        }
        ArrayList<String> lores = new ArrayList<String>();
        lores.add("\u00a7eTOTAL MINED BLOCKS: \u00a7b%mined_blocks%");
        lores.add("\u00a7eTOTAL MINED DIAMONDS: \u00a7b%mined_diamonds%");
        lores.add("\u00a7eTOTAL MINED EMERALDS: \u00a7b%mined_emeralds%");
        lores.add("\u00a7eTOTAL MINED GOLDS: \u00a7b%mined_golds%");
        lores.add("\u00a7eTOTAL MINED IRONS: \u00a7b%mined_irons%");
        lores.add("\u00a7eTOTAL MINED COALS: \u00a7b%mined_coals%");
        if (!yaml.contains("LeaderboardGUI") || yaml.getConfigurationSection("LeaderboardGUI").getKeys(false) == null) {
            yaml.set("LeaderboardGUI.TOP1.material", (Object)"PLAYER_HEAD");
            yaml.set("LeaderboardGUI.TOP1.position", (Object)14);
            yaml.set("LeaderboardGUI.TOP1.top", (Object)1);
            yaml.set("LeaderboardGUI.TOP1.name", (Object)"\u00a7c%player_name% #1");
            yaml.set("LeaderboardGUI.TOP1.lores", lores);
        }
        try {
            yaml.save(leaderboard);
        }
        catch (IOException e) {
            LOGGER.info(ChatColor.RED + "Can't save Leaderboard.yml properties");
        }
    }

    public void updateLeaderboardSchedule() {
        new BukkitRunnable(){

            public void run() {
                if (LeaderboardTemplate.updateEverySeconds < 7200) {
                    LOGGER.info(ChatColor.RED + "Leaderboard is refreshed! (every " + LeaderboardTemplate.updateEverySeconds + " seconds, update time is pretty fast, might cause lag spikes!)");
                }
                LOGGER.info(ChatColor.GREEN + "Leaderboard is refreshed! (every " + LeaderboardTemplate.updateEverySeconds + " seconds)");
                LeaderboardManager.reloadGUI();
            }
        }.runTaskTimerAsynchronously((org.bukkit.plugin.Plugin)plugin, 0L, (long)(LeaderboardTemplate.updateEverySeconds * 20));
    }

    static {
        playerDataPath = "plugins/blockbreakreward/PlayerData";
        leaderboardFilePath = "plugins/blockbreakreward/Leaderboard.yml";
    }
}

