/*
 * Decompiled with CFR 0.152.
 */
package com.blockbreakreward.PlayerLoader;

import com.blockbreakreward.MyFunc;
import com.blockbreakreward.PlayerLoader.PlayerTemplate;
import com.blockbreakreward.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerProcessor {
    public static boolean SavePlayerDataToList() {
        Plugin.players = new ArrayList<PlayerTemplate>();
        if (Plugin.playerDataFileList == null) {
            Plugin.LOGGER.info(ChatColor.YELLOW + "No data in PlayerData to be saved");
            return true;
        }
        for (File file : Plugin.playerDataFileList) {
            try {
                Bukkit.getPlayer((UUID)UUID.fromString(MyFunc.RemoveFileNameExtension(file.getName())));
            }
            catch (Exception e) {
                Plugin.LOGGER.info(ChatColor.RED + file.getName() + " is not a legal player ID, please remove it in PlayerData folder...");
                return false;
            }
            UUID id = UUID.fromString(MyFunc.RemoveFileNameExtension(file.getName()));
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            Player p = Bukkit.getOfflinePlayer((UUID)id).isOnline() ? Bukkit.getPlayer((UUID)id) : null;
            PlayerProcessor.AddToList(yaml, file, p);
        }
        return true;
    }

    public static void AddToList(YamlConfiguration yaml, File file, Player p) {
        Plugin.players.add(new PlayerTemplate(0, p, MyFunc.RemoveFileNameExtension(file.getName()), yaml.getString("playerName"), yaml.getInt("minedBlocks"), yaml.getInt("minedDiamonds"), yaml.getInt("minedEmeralds"), yaml.getInt("minedGolds"), yaml.getInt("minedIrons"), yaml.getInt("minedCoals")));
    }

    public static List<String> DefaultPlayerValueList() {
        ArrayList<String> requireStrings = new ArrayList<String>();
        requireStrings.add("playerName");
        requireStrings.add("minedBlocks");
        requireStrings.add("minedDiamonds");
        requireStrings.add("minedEmeralds");
        requireStrings.add("minedGolds");
        requireStrings.add("minedIrons");
        requireStrings.add("minedCoals");
        return requireStrings;
    }

    public static boolean SetMissedValue(File file, YamlConfiguration yaml, Player p) {
        ArrayList<String> notContaintString = new ArrayList<String>();
        for (String str : PlayerProcessor.DefaultPlayerValueList()) {
            if (yaml.contains(str)) continue;
            notContaintString.add(str);
        }
        if (notContaintString.size() > 0) {
            for (String str : notContaintString) {
                if (str.equals("playerName")) {
                    yaml.set("playerName", (Object)p.getName());
                    continue;
                }
                yaml.set(str, (Object)0);
            }
            try {
                yaml.save(file);
            }
            catch (IOException e) {
                Plugin.LOGGER.info(ChatColor.RED + "Can't save " + file.getName());
            }
            return true;
        }
        return false;
    }

    public static boolean CreatePlayerFileAndSetValue(PlayerTemplate pt, int ptPos) {
        File newPlayerFile = new File("plugins/blockbreakreward/PlayerData/" + pt.p.getUniqueId().toString() + ".yml");
        try {
            newPlayerFile.createNewFile();
        }
        catch (IOException e) {
            Plugin.LOGGER.info(ChatColor.RED + newPlayerFile.getName() + " Can't be created");
            return false;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)newPlayerFile);
        yaml.set("playerName", (Object)pt.p.getName());
        yaml.set("minedBlocks", (Object)(pt.minedAfterJoin + pt.minedBlocks));
        yaml.set("minedDiamonds", (Object)pt.minedDiamonds);
        yaml.set("minedEmeralds", (Object)pt.minedEmeralds);
        yaml.set("minedGolds", (Object)pt.minedGolds);
        yaml.set("minedIrons", (Object)pt.minedIrons);
        yaml.set("minedCoals", (Object)pt.minedCoals);
        Plugin.players.get((int)ptPos).minedAfterJoin = 0;
        try {
            yaml.save(newPlayerFile);
        }
        catch (IOException df) {
            Plugin.LOGGER.info(ChatColor.RED + "Can't save " + newPlayerFile.getName());
        }
        return false;
    }
}

