/*
 * Decompiled with CFR 0.152.
 */
package com.blockbreakreward.EventsHandler;

import com.blockbreakreward.ConfigHandler.ConfigHandler;
import com.blockbreakreward.MyFunc;
import com.blockbreakreward.MySQLConnection.MySQLHandler;
import com.blockbreakreward.PlayerLoader.PlayerProcessor;
import com.blockbreakreward.PlayerLoader.PlayerTemplate;
import com.blockbreakreward.Plugin;
import com.blockbreakreward.RewardLoader.RewardTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BlockBreakEventHandler
implements Listener {
    Plugin plugin;
    public static Double progressState = 0.0;
    boolean isRareBlock = false;

    public BlockBreakEventHandler(Plugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)plugin);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (ConfigHandler.GetEnableFullInventoryWarning()) {
            e.getPlayer().sendMessage(ChatColor.RED + ConfigHandler.GetInventoryFullWarning());
        }
        if (ConfigHandler.GetBlockToInventory() && e.getPlayer().getInventory().firstEmpty() != -1) {
            Collection items = e.getBlock().getDrops();
            for (ItemStack item : items) {
                e.getPlayer().getInventory().addItem(new ItemStack[]{item});
                e.getBlock().setType(Material.AIR);
            }
        }
        if (ConfigHandler.GetExceptBlocks().size() >= 1 && ConfigHandler.GetSpecificTools().size() >= 1 && BlockBreakEventHandler.ExceptBlocksCheck(ConfigHandler.GetExceptBlocks(), e) && BlockBreakEventHandler.SpecificToolsCheck(ConfigHandler.GetSpecificTools(), e.getPlayer())) {
            this.CheckIfPlayerInPlayersListAndAddBlock(e);
        }
    }

    public void CheckIfPlayerInPlayersListAndAddBlock(BlockBreakEvent e) {
        if (Plugin.players.size() == 0) {
            Plugin.players.add(new PlayerTemplate(0, e.getPlayer(), e.getPlayer().getUniqueId().toString(), e.getPlayer().getName(), 0, 0, 0, 0, 0, 0));
        }
        for (PlayerTemplate p : Plugin.players) {
            if (p.p == null) continue;
            if (e.getPlayer().getUniqueId().equals(p.p.getUniqueId())) {
                BlockBreakEventHandler.AddBlockBreakToPlayersList(p, BlockBreakEventHandler.PlayerDataBlocksCompare(e.getBlock().getType()), e);
                return;
            }
            if (!p.playerUUID.equals(e.getPlayer().getUniqueId().toString())) continue;
            p.p = e.getPlayer();
            BlockBreakEventHandler.AddBlockBreakToPlayersList(p, BlockBreakEventHandler.PlayerDataBlocksCompare(e.getBlock().getType()), e);
            return;
        }
    }

    public static void AddBlockBreakToPlayersList(PlayerTemplate p, Material m, BlockBreakEvent e) {
        RewardTemplate rw;
        ++p.minedAfterJoin;
        ++p.minedBlocks;
        if (m != null) {
            if (m == Material.DIAMOND_ORE) {
                ++p.minedDiamonds;
            } else if (m == Material.EMERALD_ORE) {
                ++p.minedEmeralds;
            } else if (m == Material.GOLD_ORE) {
                ++p.minedGolds;
            } else if (m == Material.IRON_ORE) {
                ++p.minedIrons;
            } else if (m == Material.COAL_ORE) {
                ++p.minedCoals;
            }
        }
        if (ConfigHandler.GetSavePlayerDataAfter() > 0 && p.minedBlocks % ConfigHandler.GetSavePlayerDataAfter() == 0) {
            for (int x = 0; x < Plugin.players.size(); ++x) {
                if (!Plugin.players.get(x).equals(p) || p.minedAfterJoin <= 0) continue;
                if (Plugin.mysql.isConnected()) {
                    MySQLHandler.SavePlayerDataToMySQL(p, x);
                    continue;
                }
                PlayerProcessor.CreatePlayerFileAndSetValue(p, x);
            }
        }
        if ((rw = MyFunc.WhatRewardPermissonTheyHave(e.getPlayer())) != null) {
            if (ConfigHandler.GetProgressActionBar()) {
                progressState = (double)p.minedBlocks % (double)rw.blockNeedToMine * (100.0 / (double)rw.blockNeedToMine);
                e.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)MyFunc.ReplacePlaceHolder(e, ConfigHandler.GetActionBarTemplate(), p)));
                p.progresstionState = progressState;
                if (progressState == 0.0) {
                    if (!ConfigHandler.GetProgessReachSound().equalsIgnoreCase("none")) {
                        e.getPlayer().playSound(e.getPlayer().getLocation(), Sound.valueOf((String)ConfigHandler.GetProgessReachSound()), 1.0f, 1.0f);
                    }
                    BlockBreakEventHandler.ExecuteCommand(e, rw.commands, rw.randomCommand, p);
                    return;
                }
            }
        } else if (ConfigHandler.GetProgressActionBar()) {
            progressState = 0.0;
            e.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)MyFunc.ReplacePlaceHolder(e, ConfigHandler.GetActionBarTemplate(), p)));
        }
        if (rw != null && !ConfigHandler.GetProgressActionBar()) {
            if (p.minedBlocks % rw.blockNeedToMine == 0) {
                BlockBreakEventHandler.ExecuteCommand(e, rw.commands, rw.randomCommand, p);
            }
        } else {
            return;
        }
    }

    public static void ExecuteCommand(BlockBreakEvent e, List<String> commands, boolean isRandom, PlayerTemplate pt) {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        Random rand = new Random();
        if (commands.size() == 1) {
            Bukkit.dispatchCommand((CommandSender)console, (String)MyFunc.ReplacePlaceHolder(e, MyFunc.RemoveForwardSlash(commands.get(0)), pt));
        } else if (commands.size() > 1) {
            if (isRandom) {
                Bukkit.dispatchCommand((CommandSender)console, (String)MyFunc.ReplacePlaceHolder(e, MyFunc.RemoveForwardSlash(commands.get(rand.nextInt(commands.size()))), pt));
            } else {
                for (String cmd : commands) {
                    Bukkit.dispatchCommand((CommandSender)console, (String)MyFunc.ReplacePlaceHolder(e, MyFunc.RemoveForwardSlash(cmd), pt));
                }
            }
            return;
        }
    }

    public static Material PlayerDataBlocksCompare(Material m) {
        if (m == Material.DIAMOND_ORE) {
            return Material.DIAMOND_ORE;
        }
        if (m == Material.EMERALD_ORE) {
            return Material.EMERALD_ORE;
        }
        if (m == Material.GOLD_ORE) {
            return Material.GOLD_ORE;
        }
        if (m == Material.IRON_ORE) {
            return Material.IRON_ORE;
        }
        if (m == Material.COAL_ORE) {
            return Material.COAL_ORE;
        }
        return null;
    }

    public static boolean SpecificToolsCheck(List<String> tools, Player p) {
        if (tools.contains("all")) {
            return true;
        }
        for (String tool : tools) {
            if (!p.getInventory().getItemInMainHand().getType().toString().toLowerCase().contains(tool)) continue;
            return true;
        }
        return false;
    }

    public static boolean ExceptBlocksCheck(List<String> blocks, BlockBreakEvent b) {
        if (blocks.contains("none")) {
            return true;
        }
        for (String block : blocks) {
            if (!block.equalsIgnoreCase(b.getBlock().getType().toString().toLowerCase())) continue;
            return false;
        }
        return true;
    }
}

